/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.uma;

import com.wily.introscope.agent.util.AgentCommandLine;
import com.wily.util.commandline.ACommandLineParser;
import com.wily.util.commandline.CommandLine;
import com.wily.util.commandline.ICommandLineParser;
import com.wily.util.commandline.ParsingException;
import com.wily.util.text.IStringLocalizer;

public class UMAgentCommandLine
extends AgentCommandLine {
    private final IStringLocalizer fLocalizer;
    private static final String[] kHelpOptions = new String[]{"-help", "-h", "-?"};
    private static final String[] kInstallBaseOptions = new String[]{"-installbase", "-i"};
    private String fInstallBase;
    private boolean fHelpMode = false;

    public UMAgentCommandLine(String[] commandLineStrings, IStringLocalizer localizer) {
        super(commandLineStrings);
        this.fLocalizer = localizer;
        this.addParser((ICommandLineParser)new HelpParser());
        this.addParser((ICommandLineParser)new InstallBaseParser());
    }

    public boolean parseCommandLine() {
        boolean result = super.parseCommandLine();
        if (!result) {
            this.printHelp(this.fException.getLocalizedMessage() + System.lineSeparator() + this.fLocalizer.IStringLocalizer_getLocalizedString("Agent_Command_Line_Options_Header"));
        }
        return result;
    }

    private void setHelpMode(boolean mode) {
        this.fHelpMode = true;
    }

    public boolean isHelpMode() {
        return this.fHelpMode;
    }

    private void setInstallBase(String base) {
        this.fInstallBase = base;
    }

    public String getInstallBase() {
        return this.fInstallBase;
    }

    public void printHelp() {
        this.printHelp(this.fLocalizer.IStringLocalizer_getLocalizedString("Agent_Command_Line_Options_Header"));
    }

    private class InstallBaseParser
    extends ACommandLineParser {
        public InstallBaseParser() {
            super(kInstallBaseOptions);
        }

        public void ICommandLineParser_parseCommand(CommandLine commandLine, String currentCommand) throws ParsingException {
            String installDir = UMAgentCommandLine.this.consumeNextCommand(UMAgentCommandLine.this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Collector_Command_Line_Missing_Argument", new String[]{currentCommand}));
            UMAgentCommandLine.this.setInstallBase(installDir);
        }

        public String ISingleCommandHelpProvider_getHelpText() {
            return "suppressed";
        }

        public boolean ISingleCommandHelpProvider_shouldSuppress() {
            return true;
        }
    }

    private class HelpParser
    extends ACommandLineParser {
        public HelpParser() {
            super(kHelpOptions);
        }

        public void ICommandLineParser_parseCommand(CommandLine commandLine, String currentCommand) {
            UMAgentCommandLine.this.setHelpMode(true);
        }

        public String ISingleCommandHelpProvider_getHelpText() {
            return UMAgentCommandLine.this.fLocalizer.IStringLocalizer_getLocalizedString("Agent_Command_Line_Help_Help_Command");
        }
    }
}

