/*
 * Decompiled with CFR 0.152.
 */
package com.ca.agent.extensions.dbmon;

import com.ca.agent.extensions.dbmon.DBMonMetricsContext;
import com.ca.agent.extensions.dbmon.DBMonitorTasksCreator;
import com.ca.agent.extensions.dbmon.helper.DBMonEncryptionHelper;
import com.ca.agent.extensions.dbmon.schema.DBMonSchemaInitializer;
import com.wily.introscope.agent.IAgent;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.io.ExtendedFile;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;

public class DBMonService {
    private static final int THREADS_DEFAULT_SIZE = 2;
    private static final String THREAD_NAME_PATTERN = "%s-%d";
    private static final ThreadPoolExecutor DB_THREADPOOL_EXECUTOR = (ThreadPoolExecutor)Executors.newFixedThreadPool(2, new ThreadFactory(){
        private final AtomicInteger counter = new AtomicInteger();

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, String.format(DBMonService.THREAD_NAME_PATTERN, "Thread-DBMonExecutor", this.counter.incrementAndGet()));
        }
    });
    private IModuleFeedbackChannel logger;

    public void startServiceFromExtension(IAgent agent, ExtendedFile extensionDir, String schemaFileName) throws Exception {
        this.logger = agent.IAgent_getModuleFeedback();
        DBMonSchemaInitializer dbMonitorSchemaInitializer = new DBMonSchemaInitializer(agent);
        List<DBMonMetricsContext> dbs = dbMonitorSchemaInitializer.initialize(extensionDir, schemaFileName);
        this.updateDBExecutors(dbs);
        DBMonEncryptionHelper passwordHelper = new DBMonEncryptionHelper();
        passwordHelper.encryptPasswordsAndUpdateFile(agent, dbs);
        new Thread((Runnable)new DBMonitorTasksCreator(this.logger, dbs, DB_THREADPOOL_EXECUTOR), "Thread-DBMonitorTasksCreator").start();
    }

    private void updateDBExecutors(List<DBMonMetricsContext> dbs) {
        int currentSize;
        int poolSize;
        int executorSize = dbs.size();
        int traceThreads = 0;
        for (DBMonMetricsContext db : dbs) {
            traceThreads += db.isDbTracesEnabled() ? 1 : 0;
        }
        if (dbs.size() <= 0) {
            executorSize = 1;
        }
        if ((poolSize = (currentSize = DB_THREADPOOL_EXECUTOR.getCorePoolSize()) + executorSize + traceThreads) > 0) {
            DB_THREADPOOL_EXECUTOR.setMaximumPoolSize(poolSize);
            DB_THREADPOOL_EXECUTOR.setCorePoolSize(poolSize);
        }
    }
}

