/*
 * Decompiled with CFR 0.152.
 */
package com.ca.agent.extensions.dbmon;

import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class InstallCert {
    private static Set<String> trustedCertsHosts = new HashSet<String>();
    private static final char[] HEXDIGITS = "0123456789abcdef".toCharArray();

    public static void installCertificate(IModuleFeedbackChannel logger, String host, int port, String keystore) {
        try {
            X509Certificate cert;
            if (trustedCertsHosts.contains(host)) {
                logger.debug("Certificate is already trusted for host - " + host);
                return;
            }
            String sslContextVal = "TLSv1.2";
            String password = "changeit";
            char SEP = File.separatorChar;
            if (StringUtils.isEmpty((String)keystore)) {
                keystore = System.getProperty("java.home") + SEP + "lib" + SEP + "security" + SEP + "cacerts";
            }
            char[] passphrase = password.toCharArray();
            File file = new File(keystore);
            logger.debug("Loading KeyStore " + file + "  with sslContext:" + sslContextVal);
            FileInputStream in = new FileInputStream(file);
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(in, passphrase);
            ((InputStream)in).close();
            SSLContext context = SSLContext.getInstance(sslContextVal);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ks);
            X509TrustManager defaultTrustManager = (X509TrustManager)tmf.getTrustManagers()[0];
            SavingTrustManager tm = new SavingTrustManager(defaultTrustManager);
            context.init(null, new TrustManager[]{tm}, null);
            SSLSocketFactory factory = context.getSocketFactory();
            logger.debug("Opening connection to " + host + ":" + port + "...");
            SSLSocket socket = (SSLSocket)factory.createSocket(host, port);
            socket.setSoTimeout(10000);
            try {
                logger.debug("Starting SSL handshake...");
                socket.startHandshake();
                socket.close();
                logger.debug("No errors, certificate is already trusted");
            }
            catch (SSLException e) {
                logger.debug((Throwable)e);
            }
            X509Certificate[] chain = tm.chain;
            if (chain == null) {
                logger.debug("Could not obtain server certificate chain");
                return;
            }
            logger.debug("Server sent " + chain.length + " certificate(s):");
            MessageDigest sha1 = MessageDigest.getInstance("SHA1");
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            for (int i = 0; i < chain.length; ++i) {
                cert = chain[i];
                logger.debug(" " + (i + 1) + " Subject " + cert.getSubjectDN());
                logger.debug("   Issuer  " + cert.getIssuerDN());
                sha1.update(cert.getEncoded());
                logger.debug("   sha1    " + InstallCert.toHexString(sha1.digest()));
                md5.update(cert.getEncoded());
                logger.debug("   md5     " + InstallCert.toHexString(md5.digest()));
            }
            int k = 0;
            cert = chain[k];
            String alias = host + "-" + (k + 1);
            ks.setCertificateEntry(alias, cert);
            FileOutputStream out = new FileOutputStream(file);
            ks.store(out, passphrase);
            ((OutputStream)out).close();
            logger.debug("Added certificate to keystore [" + file + "] using alias '" + alias + "'");
            trustedCertsHosts.add(host);
        }
        catch (Exception e) {
            logger.debug((Throwable)e);
        }
    }

    private static String toHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 3);
        for (int n : bytes) {
            sb.append(HEXDIGITS[(n &= 0xFF) >> 4]);
            sb.append(HEXDIGITS[n & 0xF]);
            sb.append(' ');
        }
        return sb.toString();
    }

    private static class SavingTrustManager
    implements X509TrustManager {
        private final X509TrustManager tm;
        private X509Certificate[] chain;

        SavingTrustManager(X509TrustManager tm) {
            this.tm = tm;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.chain = chain;
            this.tm.checkServerTrusted(chain, authType);
        }
    }
}

