/*
 * Decompiled with CFR 0.152.
 */
package com.ca.agent.extensions.dbmon.commands;

import com.ca.agent.extensions.dbmon.DBMonAPMMetric;
import com.ca.agent.extensions.dbmon.DBMonCommand;
import com.ca.agent.extensions.dbmon.DBMonException;
import com.ca.agent.extensions.dbmon.DBMonMetricsContext;
import com.ca.agent.extensions.dbmon.entity.DBMonResultSet;
import com.ca.agent.extensions.dbmon.helper.DBMonJsonPathHelper;
import com.ca.agent.extensions.dbmon.helper.FileHelper;
import com.ca.agent.extensions.dbmon.helper.JavascriptEvalHelper;
import com.ca.agent.extensions.dbmon.schema.DBMonCalcMetrics;
import com.ca.agent.extensions.dbmon.schema.DBMonMetricPath;
import com.ca.agent.extensions.dbmon.schema.DBMonSQLMetricMapping;
import com.google.gson.Gson;
import com.jayway.jsonpath.Configuration;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DBMonCalculatedMetricsCommand
implements DBMonCommand {
    private DBMonMetricsContext dbContext;
    private DBMonJsonPathHelper jsonPathHelper = new DBMonJsonPathHelper();
    private JavascriptEvalHelper evalHelper = new JavascriptEvalHelper();
    private FileHelper fileHelper = new FileHelper();
    private IModuleFeedbackChannel logger;

    @Override
    public boolean execute(DBMonMetricsContext dbContext) throws DBMonException {
        this.dbContext = dbContext;
        this.logger = dbContext.getAgent().IAgent_getModuleFeedback();
        Gson gson = new Gson();
        for (Map.Entry<String, DBMonResultSet> entrySet : dbContext.getDbResultSet().entrySet()) {
            try {
                DBMonResultSet dbMonResultSet = entrySet.getValue();
                String strResultSet = gson.toJson(dbMonResultSet);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(DBMonMetricsContext.DBMON_MODULE, "Query key:" + entrySet.getKey());
                    this.logger.debug(DBMonMetricsContext.DBMON_MODULE, "result set json object:" + strResultSet);
                }
                Object document = Configuration.defaultConfiguration().jsonProvider().parse(strResultSet);
                for (DBMonSQLMetricMapping sqlMetrics : dbContext.getDbDetailsSchema().getSqlMetricMappings()) {
                    if (!sqlMetrics.getQuery().equals(entrySet.getKey()) || sqlMetrics.getCalculatedMetrics() == null || sqlMetrics.getCalculatedMetrics().isEmpty()) continue;
                    this.generateAPMCalculatedMetric(document, sqlMetrics);
                }
            }
            catch (Exception exe) {
                this.logger.error(DBMonMetricsContext.DBMON_MODULE, "", (Throwable)exe);
            }
        }
        return true;
    }

    private void generateAPMCalculatedMetric(Object document, DBMonSQLMetricMapping sqlMetrics) {
        for (DBMonCalcMetrics dbMonCalcMetric : sqlMetrics.getCalculatedMetrics()) {
            try {
                List<String> metricExpressionList = this.jsonPathHelper.evaluateMultipleExpressions(this.logger, document, dbMonCalcMetric.getCalculation());
                List<String> metricPathList = this.extractMetricName(document, dbMonCalcMetric, metricExpressionList.size());
                for (int loopVar = 0; loopVar < metricExpressionList.size(); ++loopVar) {
                    String metricPath = metricPathList.get(loopVar);
                    long metricValue = this.evalHelper.evaluateExpression(this.logger, metricExpressionList.get(loopVar));
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Metric Expression:" + metricExpressionList.get(loopVar));
                        this.logger.debug(DBMonMetricsContext.DBMON_MODULE, "Metric Value:" + metricValue);
                        this.logger.debug(DBMonMetricsContext.DBMON_MODULE, "Metric Type:" + dbMonCalcMetric.getMetricType());
                        this.logger.debug(DBMonMetricsContext.DBMON_MODULE, "Metric Path:" + metricPath);
                    }
                    this.dbContext.getApmMetrics().add(new DBMonAPMMetric(metricPath, dbMonCalcMetric.getMetricType(), metricValue));
                }
            }
            catch (Exception exe) {
                this.logger.error(DBMonMetricsContext.DBMON_MODULE, "", (Throwable)exe);
            }
        }
    }

    private List<String> extractMetricName(Object document, DBMonCalcMetrics dbMonMetric, int resultSetLength) {
        ArrayList<String> metricPathList = new ArrayList<String>();
        for (int itr = 0; itr < resultSetLength; ++itr) {
            metricPathList.add("");
        }
        for (DBMonMetricPath path : dbMonMetric.getMetricPath()) {
            String metricPath;
            if (path.containsJsonPath()) {
                List<String> evaluatedPaths = this.jsonPathHelper.evaluate(document, path.getName());
                for (int itr = 0; itr < evaluatedPaths.size(); ++itr) {
                    metricPath = this.fileHelper.ifMetricContainsPath(evaluatedPaths.get(itr)) ? this.fileHelper.extractFileName(evaluatedPaths.get(itr)) : evaluatedPaths.get(itr);
                    if (itr >= resultSetLength) continue;
                    metricPathList.set(itr, (String)metricPathList.get(itr) + metricPath);
                }
                continue;
            }
            metricPath = path.getName();
            for (int itr = 0; itr < resultSetLength; ++itr) {
                metricPathList.set(itr, (String)metricPathList.get(itr) + metricPath);
            }
        }
        return metricPathList;
    }
}

