/*
 * Decompiled with CFR 0.152.
 */
package com.ca.agent.extensions.dbmon.schema;

import com.ca.agent.extensions.dbmon.DBMonMetricsContext;
import com.ca.agent.extensions.dbmon.schema.DBMonDetailsSchema;
import com.ca.agent.extensions.dbmon.schema.DBMonInfoSchema;
import com.ca.agent.extensions.dbmon.schema.DBMonSchema;
import com.ca.agent.extensions.dbmon.schema.DBMonSchemaType;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.connection.PlatformServerConnectionManager;
import com.wily.introscope.agent.nass.NassMetricService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DBMonMetricContextFactory {
    private NassMetricService nassMetricService;

    public List<DBMonMetricsContext> createDbContext(IAgent agent, DBMonSchema dbMonitorSchema, Map<DBMonSchemaType, DBMonDetailsSchema> metricsSchemaMap) {
        ArrayList<DBMonMetricsContext> dbMetricContextList = new ArrayList<DBMonMetricsContext>();
        agent.IAgent_getPlatformServerConnection();
        this.nassMetricService = PlatformServerConnectionManager.getNassMetricsService();
        for (DBMonInfoSchema dbInfo : dbMonitorSchema.getDatabases()) {
            DBMonDetailsSchema dbMetrics = metricsSchemaMap.get(dbInfo.getDbSchemaType());
            if (dbMetrics == null) continue;
            DBMonMetricsContext dbMetricContext = new DBMonMetricsContext(dbInfo, dbMetrics, agent);
            dbMetricContext.initializeDBMonATCManager();
            dbMetricContextList.add(dbMetricContext);
            this.addAttributeToMetric(dbInfo, dbMetricContext);
        }
        return dbMetricContextList;
    }

    private void addAttributeToMetric(DBMonInfoSchema dbInfo, DBMonMetricsContext dbMetricContext) {
        String rootPath = dbMetricContext.getRootPath();
        rootPath = rootPath.substring(0, rootPath.length() - 1);
        this.nassMetricService.addMetricAttributes(dbInfo.getDatabaseType(), rootPath, "dbPort", String.valueOf(dbInfo.getPort()));
    }
}

