/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.apmservices.client.httpclient;

import com.ca.apm.agent.apmservices.client.utils.StringUtil;

public final class APMServicesHostConnection {
    private final String protocol;
    private final String host;
    private final int port;
    private final String tenant;
    private static final String ENDPOINT_FMT = "%s://%s:%d%s";
    private static final String HOSTURL_FMT = "%s://%s:%d";

    public APMServicesHostConnection(String protocol, String host, int port, String tenant) {
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.tenant = tenant;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getTenant() {
        return this.tenant;
    }

    public String getConnectionURL(String endpoint) {
        return String.format(ENDPOINT_FMT, this.protocol, this.host, this.port, endpoint);
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof APMServicesHostConnection)) {
            return false;
        }
        APMServicesHostConnection connection = (APMServicesHostConnection)o;
        return StringUtil.equals(this.protocol, connection.protocol) && StringUtil.equals(this.host, connection.host) && this.port == connection.port && StringUtil.equals(this.tenant, connection.tenant);
    }

    public final int hashCode() {
        int hash = 7;
        hash = 31 * hash + (this.protocol == null ? 0 : this.protocol.hashCode());
        hash = 31 * hash + (this.host == null ? 0 : this.host.hashCode());
        hash = 31 * hash + (this.tenant == null ? 0 : this.tenant.hashCode());
        hash = 31 * hash + this.port;
        return hash;
    }

    public String toString() {
        return String.format(HOSTURL_FMT, this.protocol, this.host, this.port);
    }
}

