/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.apmservices.client.nass.metricbatch;

import com.ca.apm.agent.apmservices.client.nass.metricbatch.model.MetricData;
import com.ca.apm.agent.apmservices.client.nass.metricbatch.model.MetricRequest;
import com.ca.apm.agent.apmservices.client.nass.metricbatch.model.NASSMetric;
import com.ca.apm.agent.apmservices.client.nass.metricbatch.model.NASSMetricDataType;
import com.ca.apm.agent.apmservices.client.nass.metricbatch.model.NASSMetricMetadata;
import com.ca.apm.agent.apmservices.client.nass.metricbatch.model.NASSMetricValue;
import com.ca.apm.agent.apmservices.client.nass.publisher.model.IngestRecord;
import com.wily.util.feedback.IModuleFeedbackChannel;

public class MetricDataService {
    private IModuleFeedbackChannel logger;
    private String sourceName;

    public MetricDataService(IModuleFeedbackChannel logger, String sourceName) {
        this.logger = logger;
        this.sourceName = sourceName;
    }

    public MetricData getMetricBatchEntry(MetricRequest metricRequest) {
        String type = metricRequest.getType();
        String attributeName = metricRequest.getAttributeName();
        int endTime = metricRequest.getEndTime();
        String value = metricRequest.getValue();
        int interval = metricRequest.getInterval();
        int metricType = NASSMetricDataType.getMetricType(type, this.logger);
        NASSMetric metricToRegister = new NASSMetric(this.sourceName, metricType, attributeName);
        NASSMetricMetadata metadata = new NASSMetricMetadata();
        this.updateMetadata(metadata, attributeName, type, value);
        if (endTime <= 0) {
            endTime = (int)(System.currentTimeMillis() / 1000L);
        }
        Object val = NASSMetricValue.getMetricValue(type, value, this.logger);
        IngestRecord record = new IngestRecord(null, interval, endTime, val, val, val, 1L);
        return new MetricData(metricToRegister, record, metadata);
    }

    private void updateMetadata(NASSMetricMetadata metadata, String attributeName, String type, String value) {
        metadata.put("metric_name", attributeName);
        metadata.put("metric_type", type);
        metadata.put("metric_unit", value);
        metadata.put("product", "APM");
    }
}

