/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.apmservices.client.sustainability;

import com.ca.apm.agent.apmservices.client.api.APMServicesClientAPI;
import com.ca.apm.agent.apmservices.client.nass.metricbatch.model.MetricRequest;
import com.ca.apm.agent.apmservices.client.service.APMServicesClientAPIService;
import com.ca.apm.agent.apmservices.client.sustainability.PublishSustainabilityMetric;
import com.ca.apm.agent.apmservices.client.sustainability.SustainabilityRecorder;
import com.wily.introscope.agent.IAgent;
import java.util.List;

public class APMServicesSustainability {
    private static volatile APMServicesClientAPI apmServicesClientAPI;
    public static final String SUSTAINABILITY_MODULE = "APMServicesSustainability";

    private APMServicesSustainability() {
    }

    public static synchronized void init(IAgent agent) {
        if (apmServicesClientAPI == null) {
            SingletonAPMServiceClient.getInstance().setParameters(agent);
            apmServicesClientAPI = SingletonAPMServiceClient.getInstance().getApmServicesClient();
        }
    }

    public static void sendBatchMetric(List<MetricRequest> metricRequestList) {
        apmServicesClientAPI.sendBatchMetric(metricRequestList);
    }

    private static class SingletonAPMServiceClient {
        private static final SingletonAPMServiceClient INSTANCE = new SingletonAPMServiceClient();
        private APMServicesClientAPI apmServicesClientAPI;
        private IAgent agent;

        private SingletonAPMServiceClient() {
        }

        public static SingletonAPMServiceClient getInstance() {
            return INSTANCE;
        }

        public void setParameters(IAgent agent) {
            SingletonAPMServiceClient.INSTANCE.agent = agent;
        }

        public synchronized APMServicesClientAPI getApmServicesClient() {
            if (this.apmServicesClientAPI == null) {
                this.apmServicesClientAPI = this.initializeApmServicesClient();
            }
            return this.apmServicesClientAPI;
        }

        private APMServicesClientAPIService initializeApmServicesClient() {
            SustainabilityRecorder.enableSupportabilityMetric();
            PublishSustainabilityMetric.initPublisher();
            this.agent.IAgent_getModuleFeedback().info("APM Services client Sustainability started: " + Thread.currentThread().getName());
            return new APMServicesClientAPIService(this.agent, APMServicesSustainability.SUSTAINABILITY_MODULE);
        }
    }
}

