/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.apmservices.client.sustainability;

import com.ca.apm.agent.apmservices.client.metadata.register.MetricRegistrar;
import com.ca.apm.agent.apmservices.client.nass.metricbatch.model.MetricRequest;
import com.ca.apm.agent.apmservices.client.sustainability.APMServicesSustainability;
import com.ca.apm.agent.apmservices.client.sustainability.SustainabilityMetric;
import com.ca.apm.agent.apmservices.client.sustainability.SustainabilityRecorder;
import java.util.ArrayList;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class PublishSustainabilityMetric
implements Runnable {
    private static PublishSustainabilityMetric publishSupportabilityMetric = new PublishSustainabilityMetric();
    private static ScheduledThreadPoolExecutor executor = null;
    private static final String path = "Agent Stats|Sustainability|APM Services Client";

    public static void initPublisher() {
        if (executor == null) {
            executor = new ScheduledThreadPoolExecutor(1);
            executor.scheduleAtFixedRate(publishSupportabilityMetric, 500L, 7000L, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void run() {
        SustainabilityRecorder.putMetric("|Metadata:Register MetricId Cache Size", MetricRegistrar.getCount());
        ArrayList<MetricRequest> metricRequestList = new ArrayList<MetricRequest>();
        for (SustainabilityMetric m : SustainabilityRecorder.getMetricMap().values()) {
            double value = m.getValue().get();
            if (value == -1.0) {
                value = 0.0;
            }
            metricRequestList.add(new MetricRequest(path + m.getName(), this.getMetricType(m.getStatistic()), "" + value));
            m.setValue(-1L);
            m.setDataPointCount(0);
        }
        APMServicesSustainability.sendBatchMetric(metricRequestList);
        SustainabilityRecorder.putMetric(":Number of Sustainability Metric Sent", metricRequestList.size());
    }

    private String getMetricType(String statistic) {
        String metricType = "LongCounter";
        if ("SUM".equals(statistic)) {
            metricType = "PerIntervalCounter";
        } else if ("AVG".equals(statistic)) {
            metricType = "LongAverage";
        } else if ("COUNT".equals(statistic)) {
            metricType = "LongCounter";
        }
        return metricType;
    }

    private static void resetMetrics() {
        for (SustainabilityMetric m : SustainabilityRecorder.getMetricMap().values()) {
            m.setValue(-1L);
            m.setDataPointCount(0);
        }
    }
}

