/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.apmservices.client.utils;

public class StringUtil {
    private StringUtil() {
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !StringUtil.isBlank(cs);
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(CharSequence cs1, CharSequence cs2) {
        if (cs1 == cs2) {
            return true;
        }
        if (cs1 == null || cs2 == null) {
            return false;
        }
        if (cs1.length() != cs2.length()) {
            return false;
        }
        if (cs1 instanceof String && cs2 instanceof String) {
            return cs1.equals(cs2);
        }
        return StringUtil.regionMatches(cs1, false, 0, cs2, 0, cs1.length());
    }

    static boolean regionMatches(CharSequence cs, boolean ignoreCase, int thisStart, CharSequence substring, int start, int length) {
        if (cs instanceof String && substring instanceof String) {
            return ((String)cs).regionMatches(ignoreCase, thisStart, (String)substring, start, length);
        }
        int index1 = thisStart;
        int index2 = start;
        int tmpLen = length;
        int srcLen = cs.length() - thisStart;
        int otherLen = substring.length() - start;
        if (thisStart >= 0 && start >= 0 && length >= 0) {
            if (srcLen >= length && otherLen >= length) {
                while (tmpLen-- > 0) {
                    char c2;
                    char c1;
                    if ((c1 = cs.charAt(index1++)) == (c2 = substring.charAt(index2++))) continue;
                    if (!ignoreCase) {
                        return false;
                    }
                    if (Character.toUpperCase(c1) == Character.toUpperCase(c2) || Character.toLowerCase(c1) == Character.toLowerCase(c2)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

