/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.client.transport.websocket;

import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;

public class TimedPipedInputStream
extends PipedInputStream {
    private int soTimeout = 0;
    private long startTime = 0L;
    private boolean hasTimedOut = false;

    public TimedPipedInputStream() {
    }

    public TimedPipedInputStream(PipedOutputStream src) throws IOException {
        super(src);
    }

    public TimedPipedInputStream(int pipeSize) {
        super(pipeSize);
    }

    public TimedPipedInputStream(PipedOutputStream src, int pipeSize) throws IOException {
        super(src, pipeSize);
    }

    public synchronized void setSoTimeout(int timeout) throws SocketException {
        this.soTimeout = timeout;
    }

    public synchronized int getSoTimeout() throws SocketException {
        return this.soTimeout;
    }

    @Override
    public synchronized int read() throws IOException {
        this.startTime = System.currentTimeMillis();
        int ret = super.read();
        this.startTime = 0L;
        if (this.hasTimedOut) {
            this.hasTimedOut = false;
            throw new SocketTimeoutException("Websocket adapter read timeout after " + this.soTimeout + "ms");
        }
        return ret;
    }

    public synchronized void checkForTimout(long now) {
        if (this.soTimeout > 0 && this.startTime > 0L && this.startTime + (long)this.soTimeout < now) {
            this.startTime = 0L;
            if (this.in < 0) {
                this.hasTimedOut = true;
                this.in = 0;
                this.out = 0;
                this.buffer[this.in++] = -1;
                this.notifyAll();
            }
        }
    }
}

