/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.client.transport.websocket;

import com.wily.isengard.client.transport.websocket.IsengardWebSocketUrlBuilder;
import com.wily.isengard.client.transport.websocket.WebSocketAdapter;
import com.wily.isengard.postofficehub.link.net.ASocketFactory;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.IndexedProperties;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;

public class WebSocketFactory
extends ASocketFactory {
    private static final String scheme = "ws";

    public WebSocketFactory(IndexedProperties props, IModuleFeedbackChannel feedback) {
        super(props, feedback);
    }

    public static String getSchema() {
        return scheme;
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        URI uri = IsengardWebSocketUrlBuilder.buildWebSocketURI(scheme, host, port);
        WebSocketAdapter socket = new WebSocketAdapter(uri, this.getProperties(), this.getFeedbackChannel(), this.getModule());
        socket.connect();
        return socket;
    }

    public Socket createSocket(InetAddress addr, int port) throws IOException {
        String host = addr.getHostAddress();
        return this.createSocket(host, port);
    }

    public Socket createSocket(String host, int port, InetAddress localAddr, int localPort) throws IOException, UnknownHostException {
        return this.createSocket(host, port);
    }

    public Socket createSocket(InetAddress addr, int port, InetAddress localAddr, int localPort) throws IOException {
        return this.createSocket(addr, port);
    }

    public int getPort() {
        return 80;
    }

    public String getSocketType() {
        return "websocket";
    }
}

