/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.bizdef;

public final class BizDefEncapsulatedPattern {
    private final String fPattern;
    private String fReplacedEscapedPattern;
    private String fReplacedPattern;
    private String fToLowerCasePattern;
    private String fToLowerCaseReplacedPattern;
    private String fToLowerCaseOnlyPattern;

    public BizDefEncapsulatedPattern(String originalPattern) {
        this.fPattern = originalPattern;
    }

    public final String getPattern() {
        return this.fPattern;
    }

    public final String getReplacedPattern() {
        if (this.fReplacedPattern == null) {
            this.fReplacedPattern = BizDefEncapsulatedPattern.replace(this.fPattern, "*", "(.*)");
        }
        return this.fReplacedPattern;
    }

    public final String getReplacedEscapedPattern() {
        if (this.fReplacedEscapedPattern == null) {
            this.fReplacedEscapedPattern = BizDefEncapsulatedPattern.replace(BizDefEncapsulatedPattern.escapeUnsupportedRegexChars(this.getPattern()), "*", "(.*)");
        }
        return this.fReplacedEscapedPattern;
    }

    public final String getLowerCaseReplacedEscapedPattern() {
        if (this.fToLowerCasePattern == null) {
            this.fToLowerCasePattern = BizDefEncapsulatedPattern.replace(BizDefEncapsulatedPattern.escapeUnsupportedRegexChars(this.getPattern().toLowerCase()), "*", "(.*)");
        }
        return this.fToLowerCasePattern;
    }

    public final String getLowercaseOnlyPattern() {
        if (this.fToLowerCaseOnlyPattern == null) {
            this.fToLowerCaseOnlyPattern = this.getPattern().toLowerCase();
        }
        return this.fToLowerCaseOnlyPattern;
    }

    public final String getLowercaseReplacedPattern() {
        if (this.fToLowerCaseReplacedPattern == null) {
            this.fToLowerCaseReplacedPattern = this.getReplacedPattern().toLowerCase();
        }
        return this.fToLowerCaseReplacedPattern;
    }

    private static final String escapeUnsupportedRegexChars(String clearText) {
        StringBuilder result = new StringBuilder(clearText.length() * 2);
        char[] clearText2 = clearText.toCharArray();
        for (int x = 0; x < clearText.length(); ++x) {
            if (BizDefEncapsulatedPattern.requiresUnsupportedEscape(clearText2[x])) {
                result.append("\\");
            }
            result.append(clearText2[x]);
        }
        return result.toString();
    }

    private static final boolean requiresUnsupportedEscape(char inputCharacter) {
        switch (inputCharacter) {
            case '$': 
            case '&': 
            case '(': 
            case ')': 
            case '+': 
            case '-': 
            case '.': 
            case '?': 
            case '[': 
            case '\\': 
            case ']': 
            case '^': 
            case '{': 
            case '|': 
            case '}': {
                return true;
            }
        }
        return false;
    }

    private static final String replace(String source, String pattern, String replace) {
        if (source != null) {
            int len = pattern.length();
            StringBuilder sb = new StringBuilder(len * 2);
            int found = -1;
            int start = 0;
            while ((found = source.indexOf(pattern, start)) != -1) {
                sb.append(source.substring(start, found));
                sb.append(replace);
                start = found + len;
            }
            sb.append(source.substring(start));
            return sb.toString();
        }
        return "";
    }

    public final String toString() {
        return this.fPattern;
    }

    public final boolean equals(Object b) {
        return this.fPattern.equals(b);
    }

    public final int hashCode() {
        return this.fPattern.hashCode();
    }
}

