/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.detection;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.intelligent.detection.Logger;
import com.wily.introscope.agent.intelligent.detection.StackTraceRecorder;
import com.wily.introscope.agent.intelligent.entrypoint.EntryPointCandidateFinder;
import com.wily.introscope.agent.intelligent.entrypoint.EntryPointDetectionConfiguration;
import com.wily.introscope.agent.intelligent.entrypoint.EntryPointPersistenceService;
import com.wily.introscope.agent.intelligent.entrypoint.EntryPointRTAnomalyDetector;
import com.wily.introscope.agent.intelligent.entrypoint.stacktrace.StackTraceRecordingController;
import com.wily.introscope.agent.intelligent.exitpoint.ExitPointCandidateFinder;
import com.wily.introscope.agent.intelligent.exitpoint.ExitPointDetectionConfiguration;
import com.wily.introscope.probebuilder.intelligent.instrumentation.FilePersistenceService;
import com.wily.introscope.probebuilder.intelligent.instrumentation.IntelligentInstrumentationConfig;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class BoundaryDetectionExecutor {
    private static final long INITIAL_DELAY = 15L;
    private static ScheduledExecutorService schedulor;
    private static volatile boolean initialized;
    private static Collection<ScheduledFuture<?>> epFutures;

    public static void init(IAgent agent) {
        if (!initialized) {
            boolean epServiceOn;
            int poolSize = IntelligentInstrumentationConfig.INSTANCE.getBoundaryDetectionThreadPoolSize();
            schedulor = Executors.newScheduledThreadPool(poolSize, new DefaultThreadFactory());
            Logger.logDebugMessage((String)"Automatic boundary detection executor initiated.");
            EntryPointRTAnomalyDetector.initializeHelper((IAgent)agent);
            EntryPointRTAnomalyDetector.setScheduler((ScheduledExecutorService)schedulor);
            boolean bl = epServiceOn = !EntryPointDetectionConfiguration.isEntryPointShutdown();
            if (epServiceOn) {
                epFutures.add(schedulor.scheduleAtFixedRate(EntryPointCandidateFinder.getInstance(), 15L, EntryPointDetectionConfiguration.getCandidateFinderInterval(), TimeUnit.SECONDS));
                EntryPointPersistenceService detector = EntryPointPersistenceService.getInstance();
                epFutures.add(schedulor.scheduleAtFixedRate((Runnable)((Object)detector), 1L, EntryPointDetectionConfiguration.getAnomalyDetectorInterval(), TimeUnit.MINUTES));
                if (EntryPointDetectionConfiguration.isCircuitBreakerEnabled()) {
                    int entryPointCbInterval = EntryPointDetectionConfiguration.getCircuitBreakerInterval();
                    epFutures.add(schedulor.scheduleAtFixedRate(StackTraceRecordingController.getInstance(), entryPointCbInterval, entryPointCbInterval, TimeUnit.SECONDS));
                }
            }
            schedulor.scheduleAtFixedRate(ExitPointCandidateFinder.getInstance(), 15L, ExitPointDetectionConfiguration.getCandidateFinderInterval(), TimeUnit.SECONDS);
            if (ExitPointDetectionConfiguration.isCircuitBreakerEnabled()) {
                int exitPointCbInterval = ExitPointDetectionConfiguration.getCircuitBreakerInterval();
                schedulor.scheduleAtFixedRate(StackTraceRecorder.getExitPointRecorder(), exitPointCbInterval, exitPointCbInterval, TimeUnit.SECONDS);
            }
            schedulor.scheduleAtFixedRate(new FilePersistenceService(agent), 20L, IntelligentInstrumentationConfig.INSTANCE.getPersistencyServiceFrequencyInterval().intValue(), TimeUnit.SECONDS);
            initialized = true;
        }
    }

    public static void cancelEntryPointTasks() {
        Logger.logDebugMessage((String)"Cancelling EntryPoint scheduled tasks");
        for (ScheduledFuture<?> f : epFutures) {
            f.cancel(false);
        }
    }

    static boolean isEntryPointTasksActive() {
        for (ScheduledFuture<?> f : epFutures) {
            if (f.isCancelled()) continue;
            return true;
        }
        return false;
    }

    static {
        initialized = false;
        epFutures = new ConcurrentLinkedQueue();
    }

    private static class DefaultThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger POOL_NUMBER = new AtomicInteger(1);
        private static final ThreadGroup THREAD_GROUP = new ThreadGroup("Agent - Intelligent Instrumentation Boundary Detection Thread Group");
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix = "agent-ii-abt-pool-" + POOL_NUMBER.getAndIncrement() + "-thread-";

        DefaultThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(THREAD_GROUP, r, this.namePrefix + this.threadNumber.getAndIncrement());
            t.setDaemon(true);
            t.setPriority(5);
            return t;
        }
    }
}

