/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.exitpoint;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.intelligent.detection.BaseCandidateFinder;
import com.wily.introscope.agent.intelligent.detection.StackTraceRecorder;
import com.wily.introscope.agent.intelligent.exitpoint.ExitPointDetectionConfiguration;
import com.wily.introscope.agent.intelligent.exitpoint.ExitPointDetector;
import com.wily.introscope.agent.intelligent.exitpoint.ExitPointRecordingData;
import com.wily.introscope.agent.intelligent.exitpoint.WriteReadPatternDetector;
import com.wily.introscope.agent.intelligent.exitpoint.stacktrace.ExitPointStackTraceRecorder;
import com.wily.introscope.agent.intelligent.exitpoint.stacktrace.TraceRecordingTicketMaster;
import com.wily.introscope.agent.intelligent.exitpoint.stacktrace.WrappedStackTrace;
import com.wily.introscope.agent.trace.intelligent.Logger;
import com.wily.introscope.agent.trace.intelligent.SustainabilityMetricsHelper;
import com.wily.introscope.probebuilder.intelligent.instrumentation.FilePersistenceService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.WeakHashMap;

public class ExitPointCandidateFinder
extends BaseCandidateFinder {
    private static final Logger.ILoggingHandler LOGGER = ExitPointDetectionConfiguration.getLogger();
    private static final String EMPTY_METHOD_SIGNATURE = "";
    private static volatile ExitPointDetector detector = new NoOpDetector();
    private final WeakHashMap<ExitPointRecordingData, Boolean> recordingCache = new WeakHashMap();
    private final Object lockOnRecordingCache = new Object();
    private final TraceRecordingTicketMaster recordingTicketMaster = TraceRecordingTicketMaster.getInstance();
    private final Random randomWait = new Random();
    private volatile int numberIntervalsToElapse = 5;
    private volatile int waitIntervalsLimit = this.numberIntervalsToElapse + 2;

    private ExitPointCandidateFinder() {
    }

    @Override
    public void run() {
        try {
            this.numberOfRuns.incrementAndGet();
            this.doRun();
            this.recordingTicketMaster.reset();
        }
        catch (Throwable e) {
            LOGGER.logDebugMessage("Error while finding initial candidates", e);
        }
    }

    protected void doRun() {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTraceMessage(String.format("Backend Candidate Finder task got scheduled. Task id: %d", this.numberOfRuns.get()));
        }
        HashSet<StackTraceElement> candidates = new HashSet<StackTraceElement>();
        int tracesCount = 0;
        for (WrappedStackTrace[] traceBundle : this.harvest()) {
            candidates.addAll(detector.find(traceBundle));
            tracesCount += traceBundle.length;
        }
        SustainabilityMetricsHelper.reportExitPointAnalyzedStacks((int)tracesCount);
        int numCandidates = candidates.size();
        if (numCandidates > 0) {
            LOGGER.logDebugMessage("Backend Candidates: " + candidates);
            SustainabilityMetricsHelper.reportExitPointDiscovered((int)numCandidates);
        }
        ExitPointStackTraceRecorder listener = StackTraceRecorder.getExitPointRecorder();
        listener.reportTraceAnalysisResult(tracesCount, numCandidates);
        for (StackTraceElement candidate : candidates) {
            FilePersistenceService.persistInstrumentation(candidate.getClassName(), candidate.getMethodName(), EMPTY_METHOD_SIGNATURE, FilePersistenceService.EXIT_POINT_TRACINGS);
        }
        LOGGER.logTraceMessage("Backend Candidate Finder task completed. Candidates found: " + numCandidates);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<WrappedStackTrace[]> harvest() {
        ArrayList<WrappedStackTrace[]> stackTraceBundles = new ArrayList<WrappedStackTrace[]>();
        Object object = this.lockOnRecordingCache;
        synchronized (object) {
            for (ExitPointRecordingData data : this.recordingCache.keySet()) {
                int currentRunId;
                WrappedStackTrace[] traceBundle = data.harvest();
                if (traceBundle != null) {
                    stackTraceBundles.add(traceBundle);
                }
                if ((currentRunId = this.currentRunNumber()) < data.getRunSelectionId()) continue;
                if (data.isThreadPicked()) {
                    data.setThreadSelectionStatus(false);
                    data.setRunSelectionId(currentRunId + this.randomWait.nextInt(this.waitIntervalsLimit));
                    data.resetRecordingsCount();
                    continue;
                }
                if (!data.isThreadRejected()) continue;
                data.resetThreadSelectionStatus();
            }
        }
        return stackTraceBundles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerRecordingData(ExitPointRecordingData key) {
        Object object = this.lockOnRecordingCache;
        synchronized (object) {
            this.recordingCache.put(key, Boolean.TRUE);
        }
    }

    public void setNumberIntervalsToElapse(int numberIntervals) {
        this.numberIntervalsToElapse = numberIntervals;
        this.waitIntervalsLimit = this.numberIntervalsToElapse + 2;
    }

    public static void init(IAgent agent) {
        detector = new WriteReadPatternDetector(agent);
    }

    public static ExitPointCandidateFinder getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class NoOpDetector
    implements ExitPointDetector {
        private NoOpDetector() {
        }

        @Override
        public Set<StackTraceElement> find(WrappedStackTrace[] stackTraces) {
            return Collections.emptySet();
        }
    }

    private static class SingletonHolder {
        private static final ExitPointCandidateFinder INSTANCE = new ExitPointCandidateFinder();

        private SingletonHolder() {
        }
    }
}

