/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.probebuilder.intelligent.instrumentation;

import com.wily.diagnos.cmp.directives.AnalysedClassesMapInitializer;
import com.wily.diagnos.personality.java.classfile.DGClass;
import com.wily.diagnos.personality.java.classfile.DGMethod;
import com.wily.diagnos.personality.java.tracer.DGIntelligentInstrumentationStreamMethodTracerInstance;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.stat.IIntegerFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.transformer.TransformerAdministrator;
import com.wily.introscope.agent.transformer.dynamic.IClassRedefinitionDelegate;
import com.wily.introscope.agent.transformer.dynamic.IDynamicInstrumentationTransformer;
import com.wily.introscope.agent.util.ByteClassUtil;
import com.wily.introscope.probebuilder.intelligent.analysis.ExclusiveExecutionLock;
import com.wily.introscope.probebuilder.intelligent.instrumentation.IntelligentInstrumentationConfig;
import com.wily.introscope.probebuilder.intelligent.instrumentation.IntelligentInstrumentationProperties;
import com.wily.introscope.probebuilder.intelligent.instrumentation.IntelligentInstrumentationReloader;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.java.ClassName;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class LevelChangeChecker
implements Runnable {
    int lastcheckedlevel;
    IAgent fAgent;
    IDynamicInstrumentationTransformer dit;
    static int previousInstrumentationLevelInt;
    static int currentInstrumentationLevelInt;
    boolean flag = true;
    public static int fInstrumentationremovedCount;
    ScheduledExecutorService executor;
    public static ArrayList<IClassName> allClassesToReload;
    public static boolean batchInProgress;
    public static boolean levelChangedDuringBatching;
    public static int numClassesToReload;
    public static String sSustainabilityBaseMetricName;
    static IIntegerFluctuatingCounterDataAccumulator metricAccumulator;

    public LevelChangeChecker(IAgent fAgent, ScheduledExecutorService executor) {
        this.fAgent = fAgent;
        this.dit = this.dit;
        this.executor = executor;
        this.lastcheckedlevel = IntelligentInstrumentationConfig.getPreviousInstrumentationLevel();
        currentInstrumentationLevelInt = IntelligentInstrumentationConfig.getCurrentInstrumentationLevel();
        batchInProgress = false;
        levelChangedDuringBatching = false;
        DataAccumulatorFactory daf = fAgent.IAgent_getDataAccumulatorFactory();
        metricAccumulator = daf.safeGetIntegerFluctuatingCounterDataAccumulator(sSustainabilityBaseMetricName + "|Instrumentation Level:Number Of Candidate Classes For Reinstrumentation");
    }

    @Override
    public void run() {
        int currentLevel = IntelligentInstrumentationConfig.getCurrentInstrumentationLevel();
        if (IntelligentInstrumentationConfig.Flag.booleanValue()) {
            this.lastcheckedlevel = IntelligentInstrumentationConfig.getPreviousInstrumentationLevel();
            IntelligentInstrumentationConfig.Flag = false;
        }
        if (batchInProgress) {
            this.fAgent.IAgent_getModuleFeedback().info("Previous level change in progress, current  level change will be processed subsequently ..");
            levelChangedDuringBatching = true;
            return;
        }
        if (currentLevel != this.lastcheckedlevel) {
            this.getClasses();
        }
        this.lastcheckedlevel = currentLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getClasses() {
        if (!ExclusiveExecutionLock.getExclusive()) {
            ExclusiveExecutionLock.scheduleLevelChangeExecutor();
            return;
        }
        previousInstrumentationLevelInt = this.lastcheckedlevel;
        currentInstrumentationLevelInt = IntelligentInstrumentationConfig.getCurrentInstrumentationLevel();
        TransformerAdministrator tAdm = this.fAgent.IAgent_getTransformerAdministrator();
        IDynamicInstrumentationTransformer dit = tAdm.getDynamicInstrumentationTransformer();
        dit = tAdm.getDynamicInstrumentationTransformer();
        IClassRedefinitionDelegate.IRedefinedClassRepository rep = dit.getClasses();
        TreeSet methodClassPairs = new TreeSet();
        ClassName name = null;
        short[] arr = null;
        boolean breakFromLoopFlag = false;
        allClassesToReload.clear();
        fInstrumentationremovedCount = 0;
        int size = rep.getAllClassInVM().length;
        int fClassFileSizeLimit = Integer.MAX_VALUE;
        for (int i = 0; i < size; ++i) {
            Class clazz = rep.getAllClassInVM()[i];
            breakFromLoopFlag = false;
            try {
                name = ClassName.getClassName((String)clazz.getName());
                byte[] classBytes = null;
                if (!AnalysedClassesMapInitializer.isCandidateClass((String)name.getPackageAndNameString()) || (classBytes = ByteClassUtil.getBytesForClass((Class)clazz, (int)fClassFileSizeLimit, (IModuleFeedbackChannel)this.fAgent.IAgent_getModuleFeedback())) == null) continue;
                ByteArrayInputStream input = new ByteArrayInputStream(classBytes);
                DGClass modeledClass = new DGClass((InputStream)input);
                Iterator ii = modeledClass.getAllDeclaredMethods();
                while (ii.hasNext()) {
                    boolean isInstrumented;
                    DGMethod m = (DGMethod)ii.next();
                    arr = AnalysedClassesMapInitializer.getMethodMetadata((String)m.getModeledClass().getClassName().getPackageAndNameString(), (String)m.getMethodName().getNameAndSignatureString(), (String)"");
                    if (arr == null) continue;
                    short currentMethodScore = arr[0];
                    int previousLevelScore = IntelligentInstrumentationProperties.kInstrumentationLevelIntMap[previousInstrumentationLevelInt];
                    int currentLevelScore = IntelligentInstrumentationProperties.kInstrumentationLevelIntMap[currentInstrumentationLevelInt];
                    boolean wasInstrumented = currentMethodScore >= previousLevelScore;
                    boolean bl = isInstrumented = currentMethodScore >= currentLevelScore;
                    if (!wasInstrumented && isInstrumented) {
                        arr[2] = 2;
                    } else if (wasInstrumented && !isInstrumented) {
                        arr[2] = 3;
                    } else if (wasInstrumented && isInstrumented) {
                        arr[2] = 1;
                    } else if (!wasInstrumented && !isInstrumented) {
                        arr[2] = 4;
                    }
                    short id = arr[1];
                    short state = arr[2];
                    if (id != 0 && state != 1 && state != 4 && DGIntelligentInstrumentationStreamMethodTracerInstance.kAllIntelligentProbeInfo.get(id) != DGIntelligentInstrumentationStreamMethodTracerInstance.kDummyElement) {
                        List<String[]> list = DGIntelligentInstrumentationStreamMethodTracerInstance.kAllIntelligentProbeInfo;
                        synchronized (list) {
                            DGIntelligentInstrumentationStreamMethodTracerInstance.kAllIntelligentProbeInfo.add(id, DGIntelligentInstrumentationStreamMethodTracerInstance.kDummyElement);
                            DGIntelligentInstrumentationStreamMethodTracerInstance.kAllIntelligentProbeInfo.remove(id + 1);
                        }
                        if (arr[2] == 3) {
                            ++fInstrumentationremovedCount;
                        }
                    }
                    AnalysedClassesMapInitializer.updateMethodMetadata((String)m.getModeledClass().getClassName().getPackageAndNameString(), (String)m.getMethodName().getNameAndSignatureString(), (String)"", (short[])arr);
                    if (breakFromLoopFlag || arr[2] != 3 && arr[2] != 2) continue;
                    allClassesToReload.add((IClassName)name);
                    breakFromLoopFlag = true;
                }
                continue;
            }
            catch (Exception e) {
                if (this.fAgent == null || !this.fAgent.IAgent_getModuleFeedback().isDebugEnabled()) continue;
                this.fAgent.IAgent_getModuleFeedback().debug("Could not get the class name " + e.getMessage());
            }
        }
        this.scheduleReloadBatch();
    }

    private void scheduleReloadBatch() {
        int start_index = 0;
        int size = allClassesToReload.size();
        int time_counter = 0;
        int batchInterval = IntelligentInstrumentationConfig.INSTANCE.getReloadedClassesBatchInterval();
        int batchSize = IntelligentInstrumentationConfig.INSTANCE.getReloadedClassesBatchSize();
        if (batchInterval < 1) {
            batchInterval = IntelligentInstrumentationProperties.kReloadedClassesBatchIntervalDefault;
        }
        if (batchSize < 1) {
            batchSize = IntelligentInstrumentationProperties.kReloadedClassesBatchSizeDefault;
        }
        while (start_index < size) {
            if (start_index == 0) {
                numClassesToReload = size;
                if (IntelligentInstrumentationConfig.INSTANCE.isDeepTraceSustainabilityMetricsEnabled()) {
                    metricAccumulator.IIntegerCounterDataAccumulator_setValue(numClassesToReload);
                }
                batchInProgress = true;
                IntelligentInstrumentationConfig.INSTANCE.getModuleFeedbackChannel().info("Processing level change from " + IntelligentInstrumentationProperties.kInstrumentationLevelValidValues[previousInstrumentationLevelInt] + " to " + IntelligentInstrumentationProperties.kInstrumentationLevelValidValues[currentInstrumentationLevelInt] + " started");
            }
            IntelligentInstrumentationReloader reloadClassesWorker = new IntelligentInstrumentationReloader(this.fAgent, start_index, Math.min(start_index + batchSize - 1, size - 1), previousInstrumentationLevelInt, currentInstrumentationLevelInt);
            this.executor.schedule(reloadClassesWorker, (long)(batchInterval * 60 * time_counter), TimeUnit.SECONDS);
            start_index += batchSize;
            ++time_counter;
        }
    }

    public static int getCurrentInstrumentationLevelAfterProcessingStarted() {
        return currentInstrumentationLevelInt;
    }

    public static String getCurrentStatus() {
        String status = "None";
        status = batchInProgress ? IntelligentInstrumentationProperties.kInstrumentationLevelValidValues[previousInstrumentationLevelInt] + " --> " + IntelligentInstrumentationProperties.kInstrumentationLevelValidValues[currentInstrumentationLevelInt] : IntelligentInstrumentationProperties.kInstrumentationLevelValidValues[currentInstrumentationLevelInt];
        return status;
    }

    static {
        allClassesToReload = new ArrayList();
        sSustainabilityBaseMetricName = "Agent Stats|Sustainability|Deep Tracing";
        metricAccumulator = null;
    }
}

