/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.arf;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.arf.ArfCommandConnection;
import com.wily.introscope.agent.arf.ArfException;
import com.wily.introscope.agent.environment.EnvironmentAdministrator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;

public class TcpArfCommandConnection
extends ArfCommandConnection {
    private PrintWriter fOut;
    private BufferedReader fIn;
    private Socket fSocket;
    private int fPort = 0;

    public TcpArfCommandConnection(IAgent agent, Socket socket, BufferedReader input, String connMsg) throws Exception {
        super(agent, connMsg);
        this.fSocket = socket;
        InetAddress addr = this.fSocket.getInetAddress();
        this.fIpAddr = addr.getHostAddress();
        int count = 0;
        while ((this.fIpAddr == null || this.fIpAddr.isEmpty()) && count++ < 5) {
            Thread.sleep(1000L);
            this.fIpAddr = addr.getHostAddress();
        }
        if (this.fHost == null) {
            boolean fqdnEnabled = agent.IAgent_getEnvironmentAdministrator().shouldLookupCanonicalHostname();
            String hostName = addr.getHostName();
            this.fHost = fqdnEnabled ? addr.getCanonicalHostName() : (hostName.equals(this.fIpAddr) ? hostName : EnvironmentAdministrator.trimDomain(hostName));
        }
        this.fPort = this.fSocket.getPort();
        this.fOut = new PrintWriter(socket.getOutputStream(), true);
        this.fIn = input;
        if (this.fIn == null) {
            this.fIn = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        }
    }

    public TcpArfCommandConnection(IAgent agent, Socket socket) throws IOException {
        super(agent);
        this.fOut = new PrintWriter(socket.getOutputStream(), true);
        this.fIn = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        this.fPort = socket.getPort();
    }

    @Override
    protected String waitForNextMessage() {
        try {
            return this.fIn.readLine();
        }
        catch (IOException e) {
            if ("Connection reset".equals(e.getMessage())) {
                this.fFeedback.error(this.kModule, "ARF Connection socket closed:" + this.toString());
            } else {
                if (this.fListener != null) {
                    this.fListener.processMessageError(this, null, new ArfException(e.getMessage()));
                }
                this.fFeedback.error(this.kModule, "Failed to read from ARF connection: " + e.getMessage());
                this.fFeedback.debug(this.kModule, "readline(): ", e);
            }
            this.close();
            return null;
        }
    }

    @Override
    protected void writeToTransport(String message) {
        if (this.fOut != null) {
            this.fOut.print(message + "\n");
            this.fOut.flush();
        }
    }

    @Override
    public String toString() {
        return "TcpArfCommandConnection program:" + this.fProgram + " type:" + this.fProbe + " instance: " + this.fInstanceId + " port:" + this.fPort;
    }

    @Override
    protected void closeConnection() {
        try {
            if (this.fOut != null) {
                this.fOut.close();
            }
            if (this.fSocket != null) {
                this.fSocket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.fIn = null;
        this.fOut = null;
        this.fSocket = null;
    }
}

