/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.collector;

import com.wily.introscope.agent.collector.CollectorAgent;
import com.wily.introscope.agent.collector.JsonParserCommandLineOption;
import com.wily.util.commandline.ACommandLineParser;
import com.wily.util.commandline.CommandLine;
import com.wily.util.commandline.ICommandLineParser;
import com.wily.util.commandline.ParsingException;
import com.wily.util.text.IStringLocalizer;
import java.io.PrintWriter;
import java.util.Vector;

public class CollectorAgentCommandLine
extends CommandLine {
    private static final String[] kHelpOptions = new String[]{"-help", "-h", "-?"};
    private static final String[] kVerboseOptions = new String[]{"-verbose", "-v"};
    private static final String[] kInstallBaseOptions = new String[]{"-installbase", "-i"};
    private String fInstallBase;
    private final JsonParserCommandLineOption fJsonParserOption;

    public CollectorAgentCommandLine(String[] commandLineStrings, IStringLocalizer localizer) {
        super(commandLineStrings);
        Vector<ACommandLineParser> parserVector = new Vector<ACommandLineParser>();
        parserVector.addElement(new HelpParser());
        parserVector.addElement(new VerboseParser());
        this.fJsonParserOption = new JsonParserCommandLineOption();
        parserVector.addElement(this.fJsonParserOption);
        parserVector.addElement(new InstallBaseParser());
        Object[] parserArray = new ICommandLineParser[parserVector.size()];
        parserVector.copyInto(parserArray);
        this.setParsers((ICommandLineParser[])parserArray);
        try {
            this.parse();
        }
        catch (ParsingException e) {
            PrintWriter output = new PrintWriter(System.err, true);
            output.println(localizer.IStringLocalizer_getLocalizedString("Collector_Command_Line_Options_Header"));
            this.iterateParserHelp(output);
            output.flush();
        }
    }

    private void setVerboseMode(boolean mode) {
    }

    private void setHelpMode(boolean mode) {
    }

    public JsonParserCommandLineOption getJsonParserOption() {
        return this.fJsonParserOption;
    }

    private void setInstallBase(String base) {
        this.fInstallBase = base;
    }

    public String getInstallBase() {
        return this.fInstallBase;
    }

    private class InstallBaseParser
    extends ACommandLineParser {
        public InstallBaseParser() {
            super(kInstallBaseOptions);
        }

        @Override
        public void ICommandLineParser_parseCommand(CommandLine commandLine, String currentCommand) throws ParsingException {
            String installDir = CollectorAgentCommandLine.this.consumeNextCommand(CollectorAgent.GetInstance().getLocalizer().IStringLocalizer_getFormattedLocalizedString("Collector_Command_Line_Missing_Argument", new String[]{currentCommand}));
            CollectorAgentCommandLine.this.setInstallBase(installDir);
        }

        @Override
        public String ISingleCommandHelpProvider_getHelpText() {
            return "suppressed";
        }

        @Override
        public boolean ISingleCommandHelpProvider_shouldSuppress() {
            return true;
        }
    }

    private class VerboseParser
    extends ACommandLineParser {
        public VerboseParser() {
            super(kVerboseOptions);
        }

        @Override
        public void ICommandLineParser_parseCommand(CommandLine commandLine, String currentCommand) {
            CollectorAgentCommandLine.this.setVerboseMode(true);
        }

        @Override
        public String ISingleCommandHelpProvider_getHelpText() {
            return CollectorAgent.GetInstance().getLocalizer().IStringLocalizer_getLocalizedString("Collector_Command_Line_Help_Verbose_Command");
        }
    }

    private class HelpParser
    extends ACommandLineParser {
        public HelpParser() {
            super(kHelpOptions);
        }

        @Override
        public void ICommandLineParser_parseCommand(CommandLine commandLine, String currentCommand) {
            CollectorAgentCommandLine.this.setHelpMode(true);
        }

        @Override
        public String ISingleCommandHelpProvider_getHelpText() {
            return CollectorAgent.GetInstance().getLocalizer().IStringLocalizer_getLocalizedString("Collector_Command_Line_Help_Help_Command");
        }
    }
}

