/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.epagent;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.epa.IXMLHandler;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.transformer.TransformerAdministrator;
import com.wily.introscope.epagent.EPACommandLine;
import com.wily.introscope.epagent.EPAConfig;
import com.wily.introscope.epagent.EPAPlugin;
import com.wily.introscope.epagent.EPAPluginProcessor;
import com.wily.introscope.epagent.IllegalConfigurationException;
import com.wily.introscope.epagent.NetworkServer;
import com.wily.introscope.epagent.StaleMetricsProcessor;
import com.wily.introscope.epagent.cron.CronEntryScheduleException;
import com.wily.introscope.epagent.cron.CronService;
import com.wily.introscope.epagent.cron.ICronJob;
import com.wily.introscope.epagent.http.HttpServer;
import com.wily.introscope.etc.AIntroscopeInstalledApplication;
import com.wily.introscope.install.IntroscopeInstallation;
import com.wily.introscope.install.IntroscopeVersion;
import com.wily.util.feedback.ApplicationFeedback;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.heartbeat.IntervalHeartbeat;
import com.wily.util.text.IStringLocalizer;
import com.wily.util.text.MultipleResourceBundleStringLocalizer;
import com.wily.util.version.IVersion;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Iterator;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class EPAgent {
    private static EPAgent sSelf = null;
    static final Module kModule = new Module("EPAgent");
    private final IModuleFeedbackChannel fFeedback;
    private final IStringLocalizer fLocalizer;
    private final IVersion fVersion;
    private final EPACommandLine fCommandLine;
    private final AIntroscopeInstalledApplication fApplication;
    private EPAConfig fConfig;
    private HttpServer fHttpServer;
    private NetworkServer fNetworkServer;
    private IntervalHeartbeat fHeartbeat;
    private CronService fCronService;
    private static ThreadPoolExecutor fThreadPool;
    private static final String kUnknown = "unknown";

    EPAgent(String[] args) throws IOException {
        sSelf = this;
        ApplicationFeedback appFeedback = new ApplicationFeedback("EPAgent", false);
        this.fFeedback = appFeedback;
        this.fLocalizer = new MultipleResourceBundleStringLocalizer(this.fFeedback, EPAgent.class.getClassLoader(), new String[]{"com.wily.introscope.epagent.properties.EPAgentReleaseStrings", "com.wily.introscope.epagent.properties.EPAgentStrings", "com.wily.introscope.epagent.cron.CronStrings", "com.wily.introscope.properties.IntroscopeCommonStrings", "com.wily.introscope.properties.IntroscopeErrorMessages", "com.wily.introscope.properties.IntroscopeVersionStrings", "com.wily.properties.CoreCommonStrings"});
        this.fVersion = new IntroscopeVersion(this.fLocalizer);
        this.fCommandLine = new EPACommandLine(args, this.fLocalizer);
        this.fApplication = new EPAgentIntrocopeInstalledApplication(appFeedback, this.fLocalizer, this.fVersion, this.fCommandLine.getInstallBase());
    }

    private void start() throws IOException, IllegalConfigurationException, AgentNotAvailableException {
        String s;
        String agentBuildAndReleaseVersion;
        TransformerAdministrator.setTransformerRequired((boolean)false);
        File prefsFile = this.getPrefsFile(this.fApplication.getInstallation());
        System.setProperty("com.wily.introscope.agentProfile", prefsFile.getPath());
        EPAgent.GetFeedback().info(this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("EPA_Config_File_Loading", prefsFile.getPath()));
        boolean didSomething = false;
        AgentShim.getAgent().IAgent_getIndexedProperties().setProperty("introscope.agent.transactiontracer.sampling.enabled", "false");
        AgentShim.getAgent().IAgent_getIndexedProperties().setProperty("introscope.agent.stalls.enable", "false");
        String epAgentProcessID = this.getEPAgentPid();
        if (!epAgentProcessID.equals(kUnknown)) {
            DataAccumulatorFactory factory = AgentShim.getAgent().IAgent_getDataAccumulatorFactory();
            factory.safeGetStringConstantDataAccumulator("ProcessID", epAgentProcessID);
        }
        if (!(agentBuildAndReleaseVersion = this.getAgentBuildAndReleaseVersion()).equals(kUnknown)) {
            DataAccumulatorFactory factory = AgentShim.getAgent().IAgent_getDataAccumulatorFactory();
            factory.safeGetStringConstantDataAccumulator("Build and Release", agentBuildAndReleaseVersion);
        }
        this.fConfig = new EPAConfig(this.getFeedback(), this.getLocalizer());
        this.fConfig.parseConfigFile(prefsFile);
        int threadPoolSize = 0;
        if (this.fConfig.createNetworkServer()) {
            this.fNetworkServer = new NetworkServer(this.fConfig.getPluginProcessor(), this.fConfig.getNetworkPort());
            ++threadPoolSize;
            didSomething = true;
        }
        if (this.fConfig.createHttpServer()) {
            this.fHttpServer = new HttpServer(this.fConfig.getPluginProcessor(), this.fConfig.getHttpPort(), this.fConfig.getHttpServerMinThreadCount(), this.fConfig.getHttpServerMaxThreadCount(), this.fConfig.getHttpServerMaxQueuedCount(), this.fConfig.getHttpServerMaxIdleTimeMS(), this.fConfig.getHttpServerMaxIdleTime(), this.fConfig.getHttpServerAcceptQueueSize());
            ++threadPoolSize;
            didSomething = true;
        }
        this.fHeartbeat = new IntervalHeartbeat("EPA Heartbeat", this.fFeedback, this.fLocalizer, 1000L);
        this.fHeartbeat.start();
        this.fCronService = new CronService(this.fFeedback, this.fLocalizer, this.fHeartbeat);
        this.fApplication.getApplicationFeedback().setConfiguration(prefsFile.getAbsolutePath(), this.fHeartbeat, true);
        fThreadPool = (ThreadPoolExecutor)Executors.newFixedThreadPool(threadPoolSize += this.fConfig.getPlugins().size());
        if (this.fConfig.createNetworkServer()) {
            this.fNetworkServer.start();
            didSomething = true;
        }
        if (this.fConfig.createHttpServer()) {
            this.fHttpServer.start();
            didSomething = true;
        }
        Iterator<EPAPlugin> iter = this.fConfig.getPlugins().iterator();
        while (iter.hasNext()) {
            didSomething = true;
            final EPAPlugin p = iter.next();
            if (p.isStateless()) {
                if (null != p.getSchedule()) {
                    ICronJob job = new ICronJob(){

                        @Override
                        public String ICronJob_getName() {
                            return p.getName();
                        }

                        @Override
                        public void ICronJob_run() {
                            EPAgent.this.executeInPool(p);
                        }
                    };
                    try {
                        this.fCronService.addJob(job, p.getSchedule());
                        continue;
                    }
                    catch (CronEntryScheduleException e) {
                        throw new IllegalConfigurationException(e);
                    }
                }
                ITimestampedRunnable behavior = new ITimestampedRunnable(){

                    public void ITimestampedRunnable_execute(long millis) {
                        EPAgent.this.executeInPool(p);
                    }
                };
                this.fHeartbeat.addBehavior(behavior, p.getName(), true, (long)p.getInterval(), true);
                continue;
            }
            new Thread(p).start();
        }
        if (!didSomething) {
            s = this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("no_work_to_do_1P", this.fApplication.getFullName());
            throw new IllegalConfigurationException(s);
        }
        s = this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("EPA_Startup_Succeeded_Message", this.fApplication.getFullName());
        EPAgent.GetFeedback().info(s);
    }

    public static void registerXMLDataHandler(String name, IXMLHandler handler) {
        ((EPAPluginProcessor)EPAgent.sSelf.fConfig.getPluginProcessor()).registerXMLDataHandlerInternal(name, handler);
    }

    private String getAgentBuildAndReleaseVersion() {
        String agentBuildAndReleaseVersion = "Release " + this.fVersion.IVersion_getReleaseString() + " ( " + this.fVersion.IVersion_getBuildNumberString() + " ) ";
        return agentBuildAndReleaseVersion;
    }

    private String getEPAgentPid() {
        int atSymbol;
        String epAgentProcessID = ManagementFactory.getRuntimeMXBean().getName();
        if (epAgentProcessID != null && (atSymbol = epAgentProcessID.indexOf("@")) > 0) {
            return epAgentProcessID.substring(0, atSymbol);
        }
        return kUnknown;
    }

    private File getPrefsFile(IntroscopeInstallation install) throws FileNotFoundException {
        File prefsFile;
        String prefsFileName = System.getProperty("com.wily.fieldeng.epagent.properties");
        if (prefsFileName == null) {
            prefsFileName = System.getProperty("com.wily.introscope.epagent.properties");
        }
        if (prefsFileName == null) {
            prefsFile = new File(install.getInstallationSubDirectoryPath(6), "IntroscopeEPAgent.properties");
            if (!prefsFile.exists()) {
                if (this.fFeedback.isVerboseEnabled()) {
                    this.fFeedback.verbose("EPAgent cannot find " + prefsFile.getPath() + ", will now try EPAgent root directory");
                }
                prefsFile = new File("IntroscopeEPAgent.properties");
            }
        } else {
            String dir = new File(prefsFileName).getParent();
            prefsFile = dir == null ? new File(install.getInstallationSubDirectoryPath(6), prefsFileName) : new File(prefsFileName);
        }
        if (!prefsFile.exists()) {
            String message = EPAgent.GetLocalizer().IStringLocalizer_getFormattedLocalizedString("EPA_Config_File_Err_File_Not_Found", prefsFile.getPath());
            throw new FileNotFoundException(message);
        }
        if (this.fFeedback.isVerboseEnabled()) {
            try {
                this.fFeedback.verbose("EPAgent using preferences file " + prefsFile.getCanonicalPath());
            }
            catch (IOException e) {
                this.fFeedback.verbose((Throwable)e);
            }
        }
        return prefsFile;
    }

    static EPAgent GetInstance() {
        return sSelf;
    }

    static IModuleFeedbackChannel GetFeedback() {
        return EPAgent.GetInstance().getFeedback();
    }

    static IStringLocalizer GetLocalizer() {
        return EPAgent.GetInstance().getLocalizer();
    }

    IModuleFeedbackChannel getFeedback() {
        return this.fFeedback;
    }

    IStringLocalizer getLocalizer() {
        return this.fLocalizer;
    }

    EPAConfig getConfig() {
        return this.fConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            EPAgent epagent = new EPAgent(args);
            epagent.start();
            epagent.removeStaleMetrics();
            ThreadPoolExecutor threadPoolExecutor = fThreadPool;
            synchronized (threadPoolExecutor) {
                try {
                    while (!fThreadPool.isTerminated() && !fThreadPool.isShutdown()) {
                        fThreadPool.wait();
                    }
                }
                catch (InterruptedException ie) {
                    EPAgent.GetFeedback().trace(kModule, "EPAgent thread interrupted: ", (Throwable)ie);
                    throw ie;
                }
            }
        }
        catch (Throwable t) {
            IModuleFeedbackChannel f = EPAgent.GetFeedback();
            IStringLocalizer l = EPAgent.GetLocalizer();
            if (null != f && null != l) {
                String s = l.IStringLocalizer_getFormattedLocalizedString("failed_to_start_1P", t.getMessage());
                f.error(s, t);
            }
            System.err.println("EPAgent failed to start because: " + t.getMessage());
            t.printStackTrace(System.err);
        }
    }

    void executeInPool(Runnable r) {
        try {
            if (fThreadPool == null) {
                EPAgent.GetFeedback().trace(kModule, "Cannot execute plugin as thread pool has not yet been created: " + r.toString());
            } else {
                fThreadPool.execute(r);
            }
        }
        catch (Exception ie) {
            EPAgent.GetFeedback().trace(kModule, "Error executing plugin: " + r.toString(), (Throwable)ie);
        }
    }

    public void removeStaleMetrics() {
        try {
            ScheduledExecutorService scheduledThreadPool = Executors.newScheduledThreadPool(1);
            scheduledThreadPool.scheduleAtFixedRate(new StaleMetricsProcessor(EPAgent.GetFeedback(), EPAgent.GetLocalizer(), this.getConfig()), 60L, 120L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            EPAgent.GetFeedback().error(kModule, "Error executing StaleMetricsProcessor", (Throwable)e);
        }
    }

    private static class EPAgentIntrocopeInstalledApplication
    extends AIntroscopeInstalledApplication {
        EPAgentIntrocopeInstalledApplication(ApplicationFeedback feedback, IStringLocalizer localizer, IVersion version, String installationBase) throws IOException {
            super(feedback, localizer, version, localizer.IStringLocalizer_getLocalizedString("EPA_Long_Name"), localizer.IStringLocalizer_getLocalizedString("EPA_Short_Name"), installationBase);
        }

        protected void doStart() throws Exception {
        }

        protected void doStop() throws Exception {
        }
    }
}

