/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.apmservices.client.sustainability;

import com.ca.apm.agent.apmservices.client.sustainability.SustainabilityMetric;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SustainabilityRecorder {
    public static final String NUMBER = "number";
    private static Map<String, SustainabilityMetric> metricMap = new ConcurrentHashMap<String, SustainabilityMetric>();
    private static boolean enableSupportabilityMetric = false;

    private SustainabilityRecorder() {
    }

    public static void enableSupportabilityMetric() {
        enableSupportabilityMetric = true;
        metricMap.put(":Number of Sustainability Metric Sent", new SustainabilityMetric(":Number of Sustainability Metric Sent", -1L, "LONG", NUMBER, "SUM", 0));
        metricMap.put("|NASS:Metric Store Average Response Time(ms)", new SustainabilityMetric("|NASS:Metric Store Average Response Time(ms)", -1L, "LONG", "ms", "AVG", 0));
        metricMap.put("|NASS:Number of Metric Sent", new SustainabilityMetric("|NASS:Number of Metric Sent", -1L, "LONG", NUMBER, "SUM", 0));
        metricMap.put("|NASS:Number of Metric Sent Failed", new SustainabilityMetric("|NASS:Number of Metric Sent Failed", -1L, "LONG", NUMBER, "SUM", 0));
        metricMap.put("|NASS:Metric Store API Call Time(ms)", new SustainabilityMetric("|NASS:Metric Store API Call Time(ms)", -1L, "LONG", "ms", "AVG", 0));
        metricMap.put("|Metadata:Register Metric Average Response Time(ms)", new SustainabilityMetric("|Metadata:Register Metric Average Response Time(ms)", -1L, "LONG", "ms", "AVG", 0));
        metricMap.put("|Metadata:Number of Metric Register", new SustainabilityMetric("|Metadata:Number of Metric Register", -1L, "LONG", NUMBER, "SUM", 0));
        metricMap.put("|Metadata:Number of Metric Register Failed", new SustainabilityMetric("|Metadata:Number of Metric Register Failed", -1L, "LONG", NUMBER, "SUM", 0));
        metricMap.put("|Metadata:Register Metric API Call Time(ms)", new SustainabilityMetric("|Metadata:Register Metric API Call Time(ms)", -1L, "LONG", "ms", "AVG", 0));
        metricMap.put("|Metadata:Register MetricId Cache Size", new SustainabilityMetric("|Metadata:Register MetricId Cache Size", -1L, "LONG", NUMBER, "COUNT", 0));
        metricMap.put("|Metadata:Number of Register MetricId Cache Entry Removed", new SustainabilityMetric("|Metadata:Number of Register MetricId Cache Entry Removed", -1L, "LONG", NUMBER, "SUM", 0));
        metricMap.put("|NASS:Register and Store Metric Average Total Time(ms)", new SustainabilityMetric("|NASS:Register and Store Metric Average Total Time(ms)", -1L, "LONG", "ms", "AVG", 0));
        metricMap.put("|NASS:Async Register and Store Metric Average Total Time(ms)", new SustainabilityMetric("|NASS:Async Register and Store Metric Average Total Time(ms)", -1L, "LONG", "ms", "AVG", 0));
        metricMap.put("|HTTP Client:Requests Enqueue Time(ms)", new SustainabilityMetric("|HTTP Client:Requests Enqueue Time(ms)", -1L, "LONG", "ms", "AVG", 0));
    }

    public static Map<String, SustainabilityMetric> getMetricMap() {
        return metricMap;
    }

    public static void putMetric(String metrickey, long metricValue) {
        if (enableSupportabilityMetric) {
            String stat;
            SustainabilityMetric metric = metricMap.get(metrickey);
            int dataPoints = metric.getDataPointCount();
            metric.setDataPointCount(++dataPoints);
            if (metric.getValue().get() == -1L) {
                metric.setValue(0L);
            }
            if ("SUM".equals(stat = metric.getStatistic())) {
                SustainabilityRecorder.sumMetric(metric, metricValue);
            } else if ("COUNT".equals(stat)) {
                SustainabilityRecorder.countMetric(metric, metricValue);
            } else {
                SustainabilityRecorder.avgMetric(metric, metricValue);
            }
        }
    }

    private static void avgMetric(SustainabilityMetric metric, long metricValue) {
        long avg = metric.getValue().get();
        int datapoint = metric.getDataPointCount();
        avg -= avg / (long)datapoint;
        metric.setValue(avg += metricValue / (long)datapoint);
    }

    private static void sumMetric(SustainabilityMetric metric, long metricValue) {
        metric.getValue().addAndGet(metricValue);
    }

    private static void countMetric(SustainabilityMetric metric, long metricValue) {
        metric.setValue(metricValue);
    }
}

