/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.async;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.async.AsyncComponentTrace;
import com.wily.introscope.agent.async.AsyncVirtualStack;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.util.adt.ConcurrentHighPerformanceLRUHashMap;
import com.wily.util.adt.ConcurrentMapFactory;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.IntervalHeartbeat;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class AsyncComponentDownStreamCache {
    private final IAgent agent;
    protected IModuleFeedbackChannel feedback;
    protected static Module module = new Module("AsyncDownstreamCache");
    private ConcurrentMapFactory factory = null;
    private static final String kAsyncDownstreamCacheMapName = "AsyncDownstreamCache";
    private static AtomicReference<AsyncComponentDownStreamCache> instance = new AtomicReference<Object>(null);
    private final ConcurrentHighPerformanceLRUHashMap<String, Set<AsyncComponentTrace>> cache;
    private final AsyncVirtualStack stack;

    public static AsyncComponentDownStreamCache getInstance(IAgent agent, AsyncVirtualStack stack) {
        AsyncComponentDownStreamCache ref = instance.get();
        if (ref == null) {
            if (instance.compareAndSet(null, new AsyncComponentDownStreamCache(agent, stack))) {
                // empty if block
            }
            ref = instance.get();
        }
        return ref;
    }

    private AsyncComponentDownStreamCache(IAgent agent, AsyncVirtualStack stack) {
        this.agent = agent;
        this.stack = stack;
        this.feedback = agent.IAgent_getModuleFeedback();
        this.factory = (ConcurrentMapFactory)agent.IAgent_getConcurrentMapFactory();
        ConcurrentMapFactory.ConcurrentMapPolicy p = new ConcurrentMapFactory.ConcurrentMapPolicy(kAsyncDownstreamCacheMapName, ConcurrentMapFactory.ConcurrentMapType.Capped, true, ConcurrentMapFactory.ThreadLocalOption.NoThreadLocal, 16, 100, 0, 0.75f, 1000, 0);
        IntervalHeartbeat beat = agent.IAgent_getCommonHeartbeat();
        this.factory.addMapPolicy(kAsyncDownstreamCacheMapName, p, this.feedback, beat);
        this.cache = this.factory.getConcurrentCappedHashMap(kAsyncDownstreamCacheMapName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkin(String guid, AsyncComponentTrace trace) {
        Set<AsyncComponentTrace> other;
        if (guid == null) {
            return;
        }
        Set<AsyncComponentTrace> set = this.cache.get(guid);
        if (set == null && (other = this.cache.putIfAbsent(guid, set = new HashSet<AsyncComponentTrace>())) != null) {
            set = other;
        }
        Set<AsyncComponentTrace> set2 = set;
        synchronized (set2) {
            if (set.size() < 100) {
                set.add(trace);
            }
        }
    }

    public void clear(String guid) {
        this.cache.remove(guid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createAndSendTCD(String guid) {
        Set<AsyncComponentTrace> set = this.cache.remove(guid);
        if (set == null) {
            return;
        }
        Set<AsyncComponentTrace> set2 = set;
        synchronized (set2) {
            for (AsyncComponentTrace trace : set) {
                if (trace.isAlreadySentToEM()) continue;
                trace.setSentToEM();
                TransactionComponentData root0 = this.stack.realizeBizDefIfNeeded(trace.getTrace());
                root0.setParameterValue("Trace Type", "Normal");
                root0.setParameterValue("Trace Reason", "Autotrace");
                root0.setParameterValue("Autotrace Trigger Criteria", "Cross Process Trigger");
                this.stack.sendTransactionTrace(root0, guid);
            }
        }
    }
}

