/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.connection;

import com.wily.util.HashCodeUtils;
import com.wily.wilyassert.Assertion;

final class ClientInfo {
    private final String fHostName;
    private final String fIPAddress;
    private final String fProcessName;
    private final boolean fClonedAgent;

    public ClientInfo(String hostName, String ipAddress, String processName, boolean clonedAgent) {
        Assertion.wilyAssert(hostName != null, "Host Name is null.");
        Assertion.wilyAssert(ipAddress != null, "IP Address is null.");
        Assertion.wilyAssert(processName != null, "Process Name is null.");
        this.fHostName = hostName;
        this.fIPAddress = ipAddress;
        this.fProcessName = processName;
        this.fClonedAgent = clonedAgent;
    }

    public boolean isClonedAgent() {
        return this.fClonedAgent;
    }

    public String getHostName() {
        return this.fHostName;
    }

    public String getIPAddress() {
        return this.fIPAddress;
    }

    public String getProcessName() {
        return this.fProcessName;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ClientInfo)) {
            return false;
        }
        ClientInfo clientInfo = (ClientInfo)obj;
        return this.fHostName.equals(clientInfo.fHostName) && this.fIPAddress.equals(clientInfo.fIPAddress) && this.fProcessName.equals(clientInfo.fProcessName) && this.fClonedAgent == clientInfo.fClonedAgent;
    }

    public int hashCode() {
        int hashSoFar = 17;
        hashSoFar = HashCodeUtils.accumulateHashCode(hashSoFar, this.fHostName);
        hashSoFar = HashCodeUtils.accumulateHashCode(hashSoFar, this.fIPAddress);
        hashSoFar = HashCodeUtils.accumulateHashCode(hashSoFar, this.fProcessName);
        hashSoFar = HashCodeUtils.accumulateHashCode(hashSoFar, this.fClonedAgent);
        return hashSoFar;
    }
}

