/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.environment;

import com.wily.introscope.agent.util.AgentStringUtils;

public class NetworkInterfaceSpecifier {
    private final String name;
    private final int index;

    public NetworkInterfaceSpecifier(String s) throws IllegalArgumentException {
        String nameStr;
        String indexStr;
        int i = 0;
        String[] parts = AgentStringUtils.splitOnLastIndexOf(s, '.');
        if (parts.length > 1 && (indexStr = parts[1].trim()) != null) {
            try {
                i = Integer.parseInt(indexStr);
                if (i < 0) {
                    throw new IllegalArgumentException("Invalid interface index '" + indexStr + "'");
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid interface index '" + indexStr + "'");
            }
        }
        if ((nameStr = parts[0]) == null) {
            throw new IllegalArgumentException("Invalid interface index '" + s + "'");
        }
        if ((nameStr = nameStr.trim()).length() == 0) {
            throw new IllegalArgumentException("Invalid interface index '" + s + "'");
        }
        this.name = nameStr;
        this.index = i;
    }

    public NetworkInterfaceSpecifier(String name, int index) {
        this.name = name;
        this.index = index;
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public String toString() {
        return this.name + "." + this.index;
    }
}

