/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.detection.rules;

import com.wily.introscope.agent.intelligent.detection.rules.AbstractFailFastRule;
import com.wily.introscope.agent.intelligent.entrypoint.apis.ExecutionStatus;
import com.wily.introscope.agent.intelligent.entrypoint.apis.IndexAwareTraceElement;
import java.util.regex.Pattern;

public class SkipUnknownSourceFileWithDollarSignRule
extends AbstractFailFastRule {
    private final Pattern fileExtPattern;

    public SkipUnknownSourceFileWithDollarSignRule(String fileExt) {
        String regex = null;
        if (fileExt != null) {
            regex = fileExt.startsWith(".") ? fileExt.replace(".", "\\.") : "\\." + fileExt;
            regex = ".*" + regex;
            this.fileExtPattern = Pattern.compile(regex, 2);
        } else {
            this.fileExtPattern = null;
        }
    }

    @Override
    public boolean doExecute(int currentElementIndex, IndexAwareTraceElement[] trace, ExecutionStatus status) {
        boolean passes = true;
        if (this.fileExtPattern != null) {
            IndexAwareTraceElement traceElement = trace[currentElementIndex];
            String fileName = traceElement.getFileName();
            String className = traceElement.getClassName();
            passes = fileName != null ? (this.fileExtPattern.matcher(traceElement.getFileName()).matches() ? true : fileName.toLowerCase().contains("unknown source") && className != null && !className.contains("$")) : false;
        }
        return passes;
    }
}

