/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.entrypoint.apis;

import com.wily.introscope.agent.intelligent.entrypoint.apis.AStackTraceFilterChain;
import com.wily.introscope.agent.intelligent.entrypoint.apis.ExecutionStatus;
import com.wily.introscope.agent.intelligent.entrypoint.apis.IndexAwareTraceElement;
import com.wily.introscope.agent.intelligent.entrypoint.apis.Rule;
import com.wily.introscope.agent.intelligent.entrypoint.apis.RuleEngine;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class AbstractRuleEngine
extends AStackTraceFilterChain
implements RuleEngine {
    private CopyOnWriteArrayList<Rule> ruleset = new CopyOnWriteArrayList();
    private Iterator<Rule> rulesIter = this.ruleset.iterator();

    @Override
    public IndexAwareTraceElement[] preExecute(IndexAwareTraceElement[] trace) {
        return this.executeFilters(trace);
    }

    @Override
    public abstract List<IndexAwareTraceElement> execute(IndexAwareTraceElement[] var1);

    protected void executeRules(int currentElementIndex, IndexAwareTraceElement[] trace, ExecutionStatus status) {
        this.resetRuleChain();
        this.doExecuteNextRule(currentElementIndex, trace, status);
    }

    @Override
    public boolean registerRule(Rule rule) {
        return this.ruleset.addIfAbsent(rule);
    }

    @Override
    public boolean registerRules(Collection<? extends Rule> rules) {
        if (rules != null) {
            return this.ruleset.addAllAbsent(rules) > 0;
        }
        return false;
    }

    @Override
    public boolean removeRule(Rule rule) {
        return this.ruleset.remove(rule);
    }

    protected List<Rule> getRuleSet() {
        return this.ruleset;
    }

    @Override
    public void doExecuteNextRule(int currentElementIndex, IndexAwareTraceElement[] trace, ExecutionStatus status) {
        Rule nextRule = this.getNextRuleInChain();
        if (nextRule != null) {
            nextRule.execute(currentElementIndex, trace, status, this);
        }
    }

    private Rule getNextRuleInChain() {
        Rule nextRule = null;
        if (this.rulesIter.hasNext()) {
            nextRule = this.rulesIter.next();
        }
        return nextRule;
    }

    private void resetRuleChain() {
        this.rulesIter = this.ruleset.iterator();
    }
}

