/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.stalls;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blamestackfeature.IBlameStackFeatureAdministrator;
import com.wily.introscope.agent.service.ASimpleService;
import com.wily.introscope.agent.stalls.StallFeatureFactory;
import com.wily.introscope.agent.stalls.StallSweeper;
import com.wily.util.IConfigurationListener;
import com.wily.util.properties.IndexedProperties;
import java.util.Map;

public class StallService
extends ASimpleService {
    public static final String StallThresholdKey = "introscope.agent.stalls.thresholdseconds";
    public static final int DefaultStallThresholdInSeconds = 30;
    public static final String StallResolutionKey = "introscope.agent.stalls.resolutionseconds";
    public static final int DefaultStallResolutionInSeconds = 10;
    public static final String StallEnableKey = "introscope.agent.stalls.enable";
    private static IAgent fAgent;
    private static StallFeatureFactory fStallFeatureFactory;
    private int fStallThreshold;
    private int fStallResolution;
    private boolean fHasServiceStarted = false;
    private IConfigurationListener fListener;

    public StallService() {
        super("Stall Service");
    }

    @Override
    protected void doStartService(IAgent agent, Map parameters) throws Exception {
        fAgent = agent;
        this.fListener = new StallConfigurationListener(this);
        agent.addConfigurationListener(this.fListener);
        boolean enableFeature = agent.IAgent_getIndexedProperties().safeGetBooleanProperty(StallEnableKey, true, agent.IAgent_getModuleFeedback(), agent.IAgent_getStringLocalizer());
        if (!enableFeature || !agent.IAgent_getComponentTracer().isAgentOldMode()) {
            return;
        }
        this.fStallThreshold = agent.IAgent_getIndexedProperties().safeGetPositiveIntProperty(StallThresholdKey, 30, agent.IAgent_getModuleFeedback(), agent.IAgent_getStringLocalizer());
        this.fStallResolution = agent.IAgent_getIndexedProperties().safeGetPositiveIntProperty(StallResolutionKey, 10, agent.IAgent_getModuleFeedback(), agent.IAgent_getStringLocalizer());
        StallSweeper.initializeInstance(agent, this.fStallResolution * 1000);
        agent.IAgent_getModuleFeedback().info("Stall event service: stall threshold of " + this.fStallThreshold + " seconds");
        agent.IAgent_getModuleFeedback().info("Stall event service: resolution of " + this.fStallResolution + " seconds");
        IBlameStackFeatureAdministrator admin = agent.getBlameStackFeatureAdministrator();
        fStallFeatureFactory = new StallFeatureFactory(this.fStallThreshold);
        admin.addFeatureFactory(fStallFeatureFactory);
        agent.IAgent_getModuleFeedback().info("Started Stall Service");
        this.fHasServiceStarted = true;
    }

    private static class StallConfigurationListener
    implements IConfigurationListener {
        StallService parent;

        public StallConfigurationListener(StallService parent) {
            this.parent = parent;
        }

        @Override
        public void onChange(IndexedProperties props) {
            if (this.parent.fHasServiceStarted) {
                int stallResolution;
                int stallThreshold = props.safeGetPositiveIntProperty(StallService.StallThresholdKey, 30, fAgent.IAgent_getModuleFeedback(), fAgent.IAgent_getStringLocalizer());
                if (stallThreshold != this.parent.fStallThreshold) {
                    IBlameStackFeatureAdministrator admin = fAgent.getBlameStackFeatureAdministrator();
                    admin.removeFeatureFactory(fStallFeatureFactory);
                    fStallFeatureFactory = new StallFeatureFactory(stallThreshold);
                    admin.addFeatureFactory(fStallFeatureFactory);
                    fAgent.IAgent_getModuleFeedback().info("Stall event service has updated stall threshold to " + stallThreshold + " seconds");
                    this.parent.fStallThreshold = stallThreshold;
                }
                if ((stallResolution = props.safeGetPositiveIntProperty(StallService.StallResolutionKey, 10, fAgent.IAgent_getModuleFeedback(), fAgent.IAgent_getStringLocalizer())) != this.parent.fStallResolution) {
                    StallSweeper.reInitializeInstance(fAgent, stallResolution * 1000);
                    fAgent.IAgent_getModuleFeedback().info("Stall event service has updated resolution to " + stallResolution + " seconds");
                    this.parent.fStallResolution = stallResolution;
                }
            }
        }
    }
}

