/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace;

import com.wily.util.classfile.IMethodName;
import com.wily.util.classfile.IModeledMethod;
import com.wily.util.classfile.NameUtilities;

public final class ProbeIdentification {
    public static final String kClassNameMethodNameSeparator = "::";
    private final String fProbeClassName;
    private final String fProbeMethodName;
    private final String fProbeMethodDescriptor;
    private final String fRuntimeFullClassName;
    private final String fRuntimeContainerName;
    private final String fRuntimePackageName;
    private final String fRuntimeSimpleClassName;
    private final String fRuntimePackageAndClassName;
    private String fSourceFileLine = null;
    private final String identification;

    public ProbeIdentification(String probeClassName, String probeMethodName, String probeMethodDescriptor, String runtimeFullClassName) {
        this.fProbeClassName = probeClassName;
        this.fProbeMethodName = probeMethodName;
        this.fProbeMethodDescriptor = probeMethodDescriptor;
        this.fRuntimeFullClassName = runtimeFullClassName;
        this.fRuntimeContainerName = NameUtilities.parseContainerName(runtimeFullClassName);
        this.fRuntimePackageName = NameUtilities.parsePackageName(runtimeFullClassName);
        this.fRuntimeSimpleClassName = NameUtilities.parseSimpleClassName(runtimeFullClassName);
        this.fRuntimePackageAndClassName = NameUtilities.parsePackageAndClassName(this.fRuntimeFullClassName);
        this.identification = this.fProbeClassName + kClassNameMethodNameSeparator + this.fProbeMethodName;
    }

    public ProbeIdentification(IModeledMethod method) {
        IMethodName methodName = method.getMethodName();
        this.fProbeClassName = this.fRuntimeFullClassName = method.getModeledClass().getClassName().getContainerAndPackageAndNameString();
        this.fProbeMethodName = methodName.getNameString();
        this.fProbeMethodDescriptor = methodName.getSignature().getSignatureString();
        this.fRuntimeContainerName = NameUtilities.parseContainerName(this.fRuntimeFullClassName);
        this.fRuntimePackageName = NameUtilities.parsePackageName(this.fRuntimeFullClassName);
        this.fRuntimeSimpleClassName = NameUtilities.parseSimpleClassName(this.fRuntimeFullClassName);
        this.fRuntimePackageAndClassName = NameUtilities.parsePackageAndClassName(this.fRuntimeFullClassName);
        this.identification = this.fProbeClassName + kClassNameMethodNameSeparator + this.fProbeMethodName;
    }

    public final String getProbeClassName() {
        return this.fProbeClassName;
    }

    public final String getProbeMethodName() {
        return this.fProbeMethodName;
    }

    public final String getProbeMethodDescriptor() {
        return this.fProbeMethodDescriptor;
    }

    public final String getRuntimeFullClassName() {
        return this.fRuntimeFullClassName;
    }

    public final String getRuntimeSimpleClassName() {
        return this.fRuntimeSimpleClassName;
    }

    public final String getRuntimeContainerName() {
        return this.fRuntimeContainerName;
    }

    public final String getRuntimePackageName() {
        return this.fRuntimePackageName;
    }

    public final String getRuntimePackageAndClassName() {
        return this.fRuntimePackageAndClassName;
    }

    public void setSourceFileLine(String sourceFileLine) {
        this.fSourceFileLine = sourceFileLine;
    }

    public String getSourceFileLine() {
        return this.fSourceFileLine;
    }

    public final String getIdentification() {
        return this.identification;
    }
}

