/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.IFactoryLevelParameterCallback;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.FrontendTracer;
import com.wily.introscope.agent.trace.ITracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.cas.ITransactionInstanceProvider;
import com.wily.util.feedback.Module;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Stack;

public final class ProbeInformation {
    private final ProbeIdentification fProbeIdentification;
    private final ITracerFactory[] fTracerFactories;
    private final IFactoryLevelParameterCallback[] fCallbacks;
    private final boolean fNeedsInstanceReentrancy;
    private final boolean fNeedsMethodNameReentrancy;
    private final boolean fHasSandwich;
    private static final Module kModule = new Module("ProbeInformation");
    private final boolean fContainsFrontendTracer;
    private final IAgent fAgent;

    public ProbeInformation(IAgent agent, ProbeIdentification probeIdentification, ITracerFactory[] tracerFactories) {
        this.fAgent = agent;
        this.fProbeIdentification = probeIdentification;
        this.fTracerFactories = tracerFactories;
        boolean computeContainsFrontendTracer = agent != null;
        int firstNew = -1;
        int firstOld = -1;
        int lastNew = -1;
        this.fCallbacks = new IFactoryLevelParameterCallback[this.fTracerFactories.length];
        for (int i = 0; i < this.fCallbacks.length; ++i) {
            if (this.fTracerFactories[i] == null) continue;
            if (this.fTracerFactories[i] instanceof IFactoryLevelParameterCallback) {
                this.fCallbacks[i] = (IFactoryLevelParameterCallback)((Object)this.fTracerFactories[i]);
            }
            if (this.fTracerFactories[i] instanceof FrontendTracer) {
                computeContainsFrontendTracer = true;
            }
            if (tracerFactories[i] instanceof ITransactionInstanceProvider) {
                if (firstNew < 0) {
                    firstNew = i;
                } else {
                    lastNew = i;
                }
            }
            if (!(tracerFactories[i] instanceof ASingleInstanceTracerFactory) || firstOld >= 0 || firstNew < 0) continue;
            firstOld = i;
        }
        this.fHasSandwich = firstNew >= 0 && lastNew > 0 && firstOld > 0 && lastNew > firstOld;
        this.fNeedsInstanceReentrancy = this.containsReentrancyLevel(ReentrancyLevel.kInstance);
        this.fNeedsMethodNameReentrancy = this.containsReentrancyLevel(ReentrancyLevel.kMethodName);
        this.fContainsFrontendTracer = computeContainsFrontendTracer;
    }

    private String getParentsAndInterfaces(ITracerFactory iTracerFactory) {
        try {
            ArrayList<String> list = new ArrayList<String>();
            HashSet<String> unique = new HashSet<String>();
            Stack s = new Stack();
            s.add(iTracerFactory.getClass());
            while (!s.isEmpty()) {
                Class superclass;
                Class c = (Class)s.pop();
                if (!c.isInterface() && (superclass = c.getSuperclass()) != null && !superclass.equals(Object.class)) {
                    if (unique.add(superclass.getName())) {
                        list.add(superclass.getName());
                    }
                    s.push(superclass);
                }
                Class<?>[] interfaces = c.getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    if (unique.add(interfaces[i].getName())) {
                        list.add(interfaces[i].getName());
                    }
                    s.push(interfaces[i]);
                }
            }
            return list.toString();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            return "";
        }
    }

    public final ProbeIdentification getProbeIdentification() {
        return this.fProbeIdentification;
    }

    public final ITracerFactory[] getTracerFactories() {
        return this.fTracerFactories;
    }

    public final int getTracerCount() {
        return this.fTracerFactories.length;
    }

    public final boolean needsInstanceReentrancy() {
        return this.fNeedsInstanceReentrancy;
    }

    public final boolean needsMethodNameReentrancy() {
        return this.fNeedsMethodNameReentrancy;
    }

    private boolean containsReentrancyLevel(ReentrancyLevel desiredReentrancyLevel) {
        for (int i = 0; i < this.fTracerFactories.length; ++i) {
            if (desiredReentrancyLevel != this.fTracerFactories[i].ITracerFactory_getReentrancyLevel()) continue;
            return true;
        }
        return false;
    }

    public final IFactoryLevelParameterCallback[] getCallbacks() {
        return this.fCallbacks;
    }

    public InvocationData getExternalTracer(IAgent agent, Object tracedObject, boolean isOldMode) {
        InvocationData result = new InvocationData(agent, this, tracedObject, false);
        result.setContainsFrontendTracer(this.fContainsFrontendTracer);
        result.initializeForTransactionElements(isOldMode, this.fHasSandwich);
        return result;
    }

    public IAgent getAgent() {
        return this.fAgent;
    }

    public boolean hasSandwich() {
        return this.fHasSandwich;
    }
}

