/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.ejb.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.ejb.AEjbNameFormatter;
import com.wily.introscope.agent.trace.ejb.EjbHelperFactory;
import com.wily.introscope.agent.trace.ejb.IEjbHelper;
import com.wily.util.classfile.NameUtilities;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.AttributeListing;
import com.wily.util.text.IStringLocalizer;

public final class EjbContextTracer
extends ASingleInstanceTracerFactory {
    private static final String kLocalInterfaceName = "LocalInterface";
    private final IModuleFeedbackChannel fFeedback;
    private final IStringLocalizer fLocalizer;

    public EjbContextTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.fFeedback = agent.IAgent_getModuleFeedback();
        this.fLocalizer = agent.IAgent_getStringLocalizer();
    }

    @Override
    public final ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    @Override
    public final boolean ITracerFactory_isShutoff() {
        return false;
    }

    @Override
    public final void ITracer_startTrace(int tracerIndex, InvocationData data) {
        String interfaceName = null;
        Object contextObj = data.getInvocationParameterAsObject(0);
        if (contextObj == null) {
            return;
        }
        interfaceName = this.findInterfaceName(contextObj);
        if (interfaceName == null) {
            this.fFeedback.error("Could not find EJB interface from context.");
            return;
        }
        AEjbNameFormatter.setInterfaceToCache(data, interfaceName);
    }

    public String findInterfaceName(Object contextObj) {
        String interfaceName = kLocalInterfaceName;
        try {
            String name;
            Object EjbMetaData;
            Class ejbInterface;
            IEjbHelper helper = EjbHelperFactory.getEjbHelper(contextObj.getClass().getClassLoader(), this.fFeedback);
            Object EJBHome = null;
            if (helper.isEntityContext(contextObj)) {
                EJBHome = helper.getEJBHomeFromEntityContext(contextObj);
            } else if (helper.isSessionContext(contextObj)) {
                EJBHome = helper.getEJBHomeFromSessionContext(contextObj);
            } else if (helper.isMessageDrivenContext(contextObj)) {
                EJBHome = helper.getEJBHomeFromMessageDrivenContext(contextObj);
            }
            if (EJBHome != null && (ejbInterface = helper.getRemoteInterfaceClass(EjbMetaData = helper.getEJBMetaData(EJBHome))) != null && (name = ejbInterface.getName()) != null) {
                interfaceName = NameUtilities.parseSimpleClassName(name);
            }
        }
        catch (SecurityException e) {
            this.fFeedback.error("An error occurred retrieving EJB interface.");
            this.fFeedback.verbose(e);
        }
        catch (IllegalArgumentException e) {
            this.fFeedback.error("An error occurred retrieving EJB interface.");
            this.fFeedback.verbose(e);
        }
        return interfaceName;
    }

    @Override
    public final void ITracer_finishTrace(int tracerIndex, InvocationData data) {
    }
}

