/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.ejb.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.ejb.AEjbNameFormatter;
import com.wily.introscope.agent.trace.ejb.EjbHelperFactory;
import com.wily.introscope.agent.trace.ejb.IEjbHelper;
import com.wily.util.classfile.NameUtilities;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.AttributeListing;

public final class EjbDeferredContextTracer
extends ASingleInstanceTracerFactory {
    private static final String kLocalInterfaceName = "LocalInterface";

    public EjbDeferredContextTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    public final ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    @Override
    public final boolean ITracerFactory_isShutoff() {
        return false;
    }

    @Override
    public final void ITracer_startTrace(int tracerIndex, InvocationData data) {
        Object contextObj = data.getInvocationParameterAsObject(0);
        if (contextObj == null) {
            return;
        }
        String interfaceName = AEjbNameFormatter.getInterfaceFromCache(data);
        if (interfaceName != null) {
            Object alreadySetContext = AEjbNameFormatter.getContextFromCache(data.getInvocationObject());
            if (alreadySetContext == contextObj) {
                return;
            }
            AEjbNameFormatter.setInterfaceToCache(data, "com.wily.EjbDeferredContextTracer.DEFERRED");
        } else {
            AEjbNameFormatter.setInterfaceToCache(data, "com.wily.EjbDeferredContextTracer.DEFERRED");
        }
        AEjbNameFormatter.setContextToCache(data.getInvocationObject(), contextObj);
    }

    public static String findInterfaceName(Object contextObj, IModuleFeedbackChannel fFeedback) {
        String interfaceName = kLocalInterfaceName;
        try {
            String name;
            Object EjbMetaData;
            Class ejbInterface;
            IEjbHelper helper = EjbHelperFactory.getEjbHelper(contextObj.getClass().getClassLoader(), fFeedback);
            Object EJBHome = null;
            if (helper.isEntityContext(contextObj)) {
                EJBHome = helper.getEJBHomeFromEntityContext(contextObj);
            } else if (helper.isSessionContext(contextObj)) {
                EJBHome = helper.getEJBHomeFromSessionContext(contextObj);
            } else if (helper.isMessageDrivenContext(contextObj)) {
                EJBHome = helper.getEJBHomeFromMessageDrivenContext(contextObj);
            }
            if (EJBHome != null && (ejbInterface = helper.getRemoteInterfaceClass(EjbMetaData = helper.getEJBMetaData(EJBHome))) != null && (name = ejbInterface.getName()) != null) {
                interfaceName = NameUtilities.parseSimpleClassName(name);
            }
        }
        catch (SecurityException e) {
            fFeedback.error("An error occurred retrieving EJB interface.");
            fFeedback.verbose(e);
        }
        catch (IllegalArgumentException e) {
            fFeedback.error("An error occurred retrieving EJB interface.");
            fFeedback.verbose(e);
        }
        return interfaceName;
    }

    @Override
    public final void ITracer_finishTrace(int tracerIndex, InvocationData data) {
    }
}

