/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.hc2;

import com.wily.introscope.agent.trace.cas.IGathererElement;
import com.wily.introscope.agent.trace.cas.ISharedElement;
import com.wily.introscope.agent.trace.hc2.MetricGathererWrapper;
import com.wily.math.RunningLongAverage;

public class AverageMetricGathererWrapper
extends MetricGathererWrapper {
    private static final RunningLongAverage kNullEngine = new RunningLongAverage();
    private static final AverageMetricGathererWrapper kConsumedInstancer = new AverageMetricGathererWrapper(true);
    private static final AverageMetricGathererWrapper kNonConsumedInstancer = new AverageMetricGathererWrapper(false);
    private final RunningLongAverage engine;

    public static AverageMetricGathererWrapper getFactory(boolean shouldBeConsumed) {
        return shouldBeConsumed ? kConsumedInstancer : kNonConsumedInstancer;
    }

    private AverageMetricGathererWrapper(boolean shouldBeConsumedOnRead) {
        this(shouldBeConsumedOnRead, true);
    }

    private AverageMetricGathererWrapper(boolean shouldBeConsumedOnRead, boolean isOnlyInstancer) {
        super(shouldBeConsumedOnRead);
        this.engine = isOnlyInstancer ? kNullEngine : new RunningLongAverage();
    }

    @Override
    public long getValue() {
        return this.engine.getAverage();
    }

    @Override
    public IGathererElement getInstance() {
        return this.getSharedElementInstance();
    }

    @Override
    public final ISharedElement getSharedElementInstance() {
        return new AverageMetricGathererWrapper(this.shouldBeConsumendOnRead(), false);
    }

    @Override
    public final long getCount() {
        return this.engine.getCount();
    }

    @Override
    public final void combineValue(long i) {
        this.engine.combineValue(i);
    }

    @Override
    public final void reset() {
        this.engine.reset();
    }

    @Override
    public final long getMaximum() {
        return this.engine.getMaximum();
    }

    @Override
    public final long getMinimum() {
        return this.engine.getMinimum();
    }

    @Override
    protected void specificCombine(ISharedElement offered) {
        this.engine.combineValue(offered.getValue(), offered.getCount(), offered.getMinimum(), offered.getMaximum());
    }

    public final void merge(long value, long start) {
        super.combineTime(start);
        this.engine.combineValue(value);
    }

    public final void merge(int value, long start) {
        super.combineTime(start);
        this.engine.combineValue(value);
    }

    @Override
    protected void decrease() {
        throw new Error("Not Implemented");
    }

    @Override
    protected void increase() {
        throw new Error("Not Implemented");
    }

    @Override
    public final void resetMinMax() {
        this.engine.reset();
    }

    @Override
    public final void setValue(long value) {
    }

    @Override
    protected void forceSpecificCombine(ISharedElement offered) {
        this.specificCombine(offered);
    }
}

