/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.intelligent;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.intelligent.AutotraceCrossprocessDownstreamGuidClamp;
import com.wily.introscope.agent.trace.intelligent.AutotraceCrossprocessWorkerFrequency;
import com.wily.introscope.agent.trace.intelligent.DownStreamListenerService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class DownStreamListenerExecutor {
    static ScheduledExecutorService executor;
    static Runnable downstreamListenerWorker;

    public static void startExecutor(final IAgent agent) {
        executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){
            AtomicInteger count = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = agent.IAgent_getAgentThreadFactory().IThreadFactory_createNewThread("Agent Downstream Listener " + this.count.incrementAndGet(), r);
                thread.setDaemon(true);
                return thread;
            }
        });
        downstreamListenerWorker = new DownStreamListenerService(AutotraceCrossprocessDownstreamGuidClamp.fValue, agent);
    }

    public static DownStreamListenerService getDownStreamListenerWorker() {
        return (DownStreamListenerService)downstreamListenerWorker;
    }

    public static void scheduleDownstreamListenerExecutor() {
        executor.scheduleAtFixedRate(downstreamListenerWorker, 0L, AutotraceCrossprocessWorkerFrequency.fValue, TimeUnit.MILLISECONDS);
    }
}

