/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.io.clamp;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.io.clamp.ASocketClampManager;
import com.wily.introscope.agent.trace.io.clamp.TracedSockets;
import com.wily.util.properties.AttributeListing;
import java.net.InetSocketAddress;

public class ChannelInitClampManager
extends ASocketClampManager {
    public ChannelInitClampManager(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    protected void decideOnClamp(InvocationData data) {
        boolean traced = false;
        try {
            Object address = data.getInvocationParameterAsObject(0);
            if (!(address instanceof InetSocketAddress)) {
                data.setSocketClamp(true);
                return;
            }
            InetSocketAddress endPoint = (InetSocketAddress)address;
            traced = TracedSockets.isTraced(endPoint);
            if (!traced) {
                traced = TracedSockets.add(endPoint);
            }
            if (!traced) {
                data.setSocketClamp(!traced);
            }
        }
        catch (Exception e) {
            this.getModuleFeedback().error(e);
        }
    }
}

