/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.nano;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.stat.ILongAverageDataAccumulator;
import com.wily.introscope.agent.trace.ASingleMetricTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.AttributeListing;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;

public class MethodNanoCPUTimer
extends ASingleMetricTracerFactory {
    private static boolean fIsLoaded;
    private static ThreadMXBean fThreadBean;

    private static synchronized void loadThreadMXBean(IAgent agent) {
        if (!fIsLoaded) {
            IModuleFeedbackChannel feedback = agent.IAgent_getModuleFeedback();
            try {
                ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
                if (threadBean != null) {
                    if (threadBean.isThreadCpuTimeSupported()) {
                        if (threadBean.isThreadCpuTimeEnabled()) {
                            fThreadBean = threadBean;
                        } else {
                            feedback.debug("ThreadMXBean.isThreadCpuTimeEnabled returned false");
                        }
                    } else {
                        feedback.debug("ThreadMXBean.isThreadCpuTimeSupported returned false");
                    }
                } else {
                    feedback.debug("Null ThreadMXBean returned from the ManagementFactory");
                }
            }
            catch (Throwable t) {
                feedback.error("Unable to load ManagementFactory", t);
            }
            fIsLoaded = true;
        }
    }

    public MethodNanoCPUTimer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        MethodNanoCPUTimer.loadThreadMXBean(agent);
    }

    @Override
    protected IDataAccumulator createDataAccumulator(String formattedMetricName) {
        return this.getDataAccumulatorFactory().safeGetLongAverageDataAccumulator(formattedMetricName);
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        ThreadMXBean threadBean = fThreadBean;
        if (threadBean != null && data.getCPUStartTimeNanos() < 0L) {
            data.setCPUStartTimeNanos(threadBean.getCurrentThreadCpuTime());
        }
        this.addToBlameStackIfEnabled(data);
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        long startTime;
        BlameStackSnapshot snapshot = this.removeFromBlameStackIfEnabledAndReturnSnapshot(data);
        ThreadMXBean threadBean = fThreadBean;
        if (threadBean != null && (startTime = data.getCPUStartTimeNanos()) >= 0L) {
            ILongAverageDataAccumulator average;
            long endTime = data.getCPUFinishTimeNanos();
            if (endTime < 0L) {
                endTime = threadBean.getCurrentThreadCpuTime();
                data.setCPUFinishTimeNanos(endTime);
            }
            if (!(average = (ILongAverageDataAccumulator)this.getDataAccumulator(data)).IDataAccumulator_isShutOff()) {
                average.ILongAggregatingDataAccumulator_recordDataPoint(this.elapsedTime(startTime, endTime), snapshot);
            }
        }
    }

    private long elapsedTime(long start, long finish) {
        return finish > start ? finish - start : 0L;
    }
}

