/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.nio;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.IIntegerRateDataAccumulator;
import com.wily.introscope.agent.trace.ABundledTracerFactory;
import com.wily.introscope.agent.trace.ITracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.nio.SocketAcceptMappingTracer;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;

public abstract class ChannelMethodResultRateTracer
extends ABundledTracerFactory
implements ITracer {
    protected final ReentrancyLevel fReentrancyLevel = this.calculateReentrancyLevel(ReentrancyLevel.kNone);

    public ChannelMethodResultRateTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    protected abstract IIntegerRateDataAccumulator createDataAccumulator(InvocationData var1);

    protected final IIntegerRateDataAccumulator createDataAccumulator(String formattedMetricName) {
        return this.getDataAccumulatorFactory().safeGetIntegerRateDataAccumulator(formattedMetricName);
    }

    @Override
    public final ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return this.fReentrancyLevel;
    }

    @Override
    public final boolean ITracerFactory_isShutoff() {
        return false;
    }

    @Override
    public final void ITracer_startTrace(int tracerIndex, InvocationData data) {
    }

    @Override
    public final void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        if (SocketAcceptMappingTracer.checkWithOverheadMgr()) {
            return;
        }
        IIntegerRateDataAccumulator rate = this.createDataAccumulator(data);
        if (rate != null && !rate.IDataAccumulator_isShutOff()) {
            if (data.hasMethodResultAvailable()) {
                Object returnValue = data.getInvocationReturnValueAsObject();
                if (returnValue == null) {
                    return;
                }
                if (returnValue instanceof Number) {
                    int returnValueAsInt = ((Number)returnValue).intValue();
                    rate.IIntegerRateDataAccumulator_addBatchIncidents(returnValueAsInt);
                } else {
                    Assertion.wilyAssert("Instrumented method return value is not a Number");
                }
            } else {
                Assertion.wilyAssert("Instrumented method has no return value");
            }
        }
    }

    @Override
    public final void ITracerFactory_releaseTracer(int tracerIndex, ITracer tracer) {
    }
}

