/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.nio;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.IIntegerRateDataAccumulator;
import com.wily.introscope.agent.trace.ITracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.nio.ChannelMethodResultRateTracer;
import com.wily.introscope.agent.trace.nio.DatagramChannelMap;
import com.wily.introscope.agent.trace.nio.SocketAcceptMappingTracer;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;
import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;

public final class DatagramMethodResultRateTracer
extends ChannelMethodResultRateTracer
implements ITracer {
    public DatagramMethodResultRateTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    public final ITracer ITracerFactory_allocateTracer(int tracerIndex, InvocationData data) {
        if (SocketAcceptMappingTracer.checkWithOverheadMgr()) {
            return null;
        }
        if (data.isSocketClamped()) {
            return null;
        }
        Object invocationObject = data.getInvocationObject();
        if (invocationObject instanceof DatagramChannel) {
            return this;
        }
        Assertion.wilyAssert("Instrumentation error: instrumented object is not a DatagramChannel");
        return null;
    }

    @Override
    protected final IIntegerRateDataAccumulator createDataAccumulator(InvocationData data) {
        String formattedName;
        InetSocketAddress remoteAddress;
        DatagramChannel channel = (DatagramChannel)data.getInvocationObject();
        if (DatagramChannelMap.isRequired(channel, remoteAddress = (InetSocketAddress)channel.socket().getRemoteSocketAddress(), this.getAgent()) && (formattedName = this.formatParameterizedName(data)) != null) {
            return this.createDataAccumulator(formattedName);
        }
        return null;
    }
}

