/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.util;

import com.wily.introscope.agent.intelligent.detection.AutomaticBoundaryDetectionAdmin;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketImpl;

public class SocketUtils {
    public static SocketImpl getSocketImpl(Object socket, boolean log) {
        if (socket == null) {
            return null;
        }
        Object retrunVal = null;
        try {
            Method _getImpl;
            if (socket instanceof Socket) {
                _getImpl = Socket.class.getDeclaredMethod("getImpl", null);
                _getImpl.setAccessible(true);
                retrunVal = (SocketImpl)_getImpl.invoke(socket, null);
            } else if (socket instanceof ServerSocket) {
                _getImpl = ServerSocket.class.getDeclaredMethod("getImpl", null);
                _getImpl.setAccessible(true);
                retrunVal = (SocketImpl)_getImpl.invoke(socket, null);
            }
            if (retrunVal != null) {
                if (log) {
                    SocketUtils.logDebugMessage("SocketImpl for socket ( " + socket + "," + socket.hashCode() + "):" + retrunVal + ", hash " + retrunVal.hashCode());
                }
                if (retrunVal.getClass().getSuperclass().getName().equals("java.net.DelegatingSocketImpl")) {
                    Method _delegate = SocketUtils.findMethod(retrunVal.getClass(), "delegate", false);
                    if (_delegate != null) {
                        _delegate.setAccessible(true);
                        retrunVal = (SocketImpl)_delegate.invoke(retrunVal, null);
                    } else if (log) {
                        SocketUtils.logDebugMessage("@getSocketImpl Shoundnt have happened!!");
                    }
                    if (log) {
                        SocketUtils.logDebugMessage("@getSocketImpl  got DelegatingSocketImpl: " + retrunVal.getClass().getName() + "hash: " + retrunVal.hashCode() + " for socket " + socket + "(" + socket.hashCode() + ")");
                    }
                } else if (log) {
                    SocketUtils.logDebugMessage("@getSocketImpl not a  DelegatingSocketImpl: " + retrunVal + " hash:  " + retrunVal.hashCode());
                }
                return retrunVal;
            }
            throw new Exception("Unknown Socket Object");
        }
        catch (Exception e) {
            SocketUtils.logDebugMessage("Unable to get impl from Socket/ServerSocket obj " + e);
            return null;
        }
    }

    public static SocketImpl getDebugSocketImpl(Object socket) {
        return SocketUtils.getSocketImpl(socket, true);
    }

    public static SocketImpl getSocketImpl(Object socket) {
        return SocketUtils.getSocketImpl(socket, false);
    }

    static Method findMethod(Class input, String methodName, boolean log) {
        if (log) {
            SocketUtils.logDebugMessage("@findMethod");
        }
        Method returnValue = null;
        for (Class currentClass = input; returnValue == null && currentClass != null; currentClass = currentClass.getSuperclass()) {
            if (log) {
                SocketUtils.logDebugMessage(" checking class " + currentClass + " for method " + methodName);
            }
            try {
                returnValue = currentClass.getDeclaredMethod(methodName, null);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return returnValue;
    }

    public static void logDebugMessage(String message) {
    }

    public static String getStackString() {
        try {
            StringWriter stacktrace = new StringWriter();
            new Throwable().printStackTrace(new PrintWriter(stacktrace));
            return stacktrace.toString();
        }
        catch (Exception e) {
            return "null";
        }
    }

    public static final boolean suggestStackTraceRecording() {
        return AutomaticBoundaryDetectionAdmin.getInstance().getStrackTraceRecorder().record();
    }

    public static SocketImpl getImplementationFromSocket(Object socket) {
        if (socket == null) {
            return null;
        }
        try {
            if (socket instanceof Socket) {
                Method _getImpl = Socket.class.getDeclaredMethod("getImpl", null);
                _getImpl.setAccessible(true);
                return (SocketImpl)_getImpl.invoke(socket, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static class SocketPojo {
        InetAddress _inetAddress;
        Integer _port;
        InetAddress _localAddress;
        Integer _localPort;

        public SocketPojo(SocketImpl impl) throws Exception {
            try {
                Method _getInetAddress = SocketImpl.class.getDeclaredMethod("getInetAddress", null);
                _getInetAddress.setAccessible(true);
                this._inetAddress = (InetAddress)_getInetAddress.invoke((Object)impl, null);
                Method _getPort = SocketImpl.class.getDeclaredMethod("getPort", null);
                _getPort.setAccessible(true);
                this._port = (Integer)_getPort.invoke((Object)impl, null);
                Method _getLocalPort = SocketImpl.class.getDeclaredMethod("getLocalPort", null);
                _getLocalPort.setAccessible(true);
                this._localPort = (Integer)_getLocalPort.invoke((Object)impl, null);
                this._localAddress = (InetAddress)impl.getOption(15);
            }
            catch (Exception e) {
                SocketUtils.logDebugMessage("Error creating SocketPojo " + e);
                throw e;
            }
        }

        public SocketAddress getRemoteSocketAddress() {
            return new InetSocketAddress(this.getInetAddress(), this.getPort());
        }

        public InetAddress getInetAddress() {
            return this._inetAddress;
        }

        public int getPort() {
            return this._port;
        }

        public int getLocalPort() {
            return this._localPort;
        }

        public InetAddress getLocalAddress() {
            return this._localAddress;
        }

        private Class getSocketImplLayer(Class<?> impl) {
            Class<?> returnClass = impl;
            System.out.println("getSocketImplLayer: returnClass: " + returnClass.getName());
            if (returnClass.getName().equals("java.net.SocketImpl")) {
                return returnClass;
            }
            if (returnClass.getName().equals("java.lang.Object")) {
                return null;
            }
            return this.getSocketImplLayer(returnClass.getSuperclass());
        }

        public String toString() {
            StringBuilder temp = new StringBuilder();
            temp.append(" Address: " + this._inetAddress);
            temp.append(", port: " + this._port);
            temp.append(", local Address: " + this._localAddress);
            temp.append(", local port: " + this._localPort);
            return temp.toString();
        }
    }
}

