/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.api.instrument;

import com.wily.introscope.agent.AgentShim;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.lang.module.ModuleFinder;
import java.lang.ref.WeakReference;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class JPMSClassFileTransformerImpl
implements ClassFileTransformer {
    private WeakReference<Instrumentation> instrumentationObj;
    private Set<Module> unnamedModules = new HashSet<Module>();
    private List<String> exportHistory = new ArrayList<String>();
    private boolean exportEverything;
    private IModuleFeedbackChannel logger;

    public JPMSClassFileTransformerImpl(Instrumentation instrumentation) throws Exception {
        try {
            this.logger = AgentShim.getAgent().IAgent_getModuleFeedback();
            this.logger.info("Using Modular (java9+) ClassFileTransformer");
            this.instrumentationObj = new WeakReference<Instrumentation>(instrumentation);
            this.unnamedModules.add(this.getClass().getModule());
            this.logDebugMsg(String.format(" Agent Loader: %s, Agent Module: %s", this.getClass().getClassLoader(), this.getClass().getModule()));
            this.processAlreadyLoadedClasses();
        }
        catch (Exception e) {
            this.logDebugMsg("UnExpected Error initialising JPMS ClassFileTransformer " + e);
            throw new Exception("UnExpected Error initialising JPMS ClassFileTransformer " + e);
        }
    }

    private void processAlreadyLoadedClasses() {
        for (Class currentItem : ((Instrumentation)this.instrumentationObj.get()).getAllLoadedClasses()) {
            this.validateAndRedefine(currentItem.getModule(), currentItem.getName());
        }
    }

    @Override
    public byte[] transform(Module module, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        this.validateAndRedefine(module, className);
        return null;
    }

    private void validateAndRedefine(Module m, String className) {
        try {
            if (m == null || m.getName() == null) {
                return;
            }
            String moduleName = m.getName();
            if (this.exportHistory.contains(moduleName)) {
                return;
            }
            if (this.instrumentationObj.get() != null && !((Instrumentation)this.instrumentationObj.get()).isModifiableModule(m)) {
                this.logDebugMsg(String.format("Module %s is not modifiable ", moduleName));
                return;
            }
            if (ModuleFinder.ofSystem().find(moduleName).isPresent()) {
                return;
            }
            HashMap<String, Set<Module>> extraExports = new HashMap<String, Set<Module>>();
            this.exportHistory.add(moduleName);
            for (String currentPackage : m.getPackages()) {
                extraExports.put(currentPackage, this.unnamedModules);
            }
            this.logDebugMsg("About to redefine module for class: " + className);
            this.doRedefine(m, null, extraExports, extraExports);
        }
        catch (Exception exp) {
            this.logDebugMsg("Exception in validateAndRedefine: " + exp);
        }
        catch (Error err) {
            this.logDebugMsg("Error in validateAndRedefine: " + err);
        }
    }

    private void doRedefine(Module m, Set<Module> extraReads, Map<String, Set<Module>> extraExports, Map<String, Set<Module>> extraOpens) throws Exception {
        try {
            if (this.instrumentationObj.get() != null && extraExports.size() != 0) {
                this.logDebugMsg("Redefining " + m.getName() + ": " + extraExports);
                this.logger.info("Redefining " + m.getName() + ": " + extraExports);
                ((Instrumentation)this.instrumentationObj.get()).redefineModule(m, extraReads == null ? Set.of() : extraReads, extraExports == null ? Map.of() : extraExports, extraOpens == null ? Map.of() : extraOpens, Set.of(), Map.of());
            }
        }
        catch (Exception e) {
            throw new Exception("Error in doRedefine: " + e);
        }
    }

    private void logDebugMsg(String msg) {
    }
}

