/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.extensions.agent.socketfactory;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.extension.ExtensionAdministrator;
import com.wily.introscope.agent.server.property.ServerUrlProperty;
import com.wily.isengard.postofficehub.link.net.ISocketFactory;
import com.wily.util.extension.ExtensionUtilities;
import com.wily.util.extension.IPlugin;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class SocketFactoryAdministrator {
    private static final String kSocketFactoryPluginType = "socketfactory";
    private static final int kExpectedVersion = 1;
    private final IAgent fAgent;
    private final List<Class<?>> fClasses;

    public List<Class<?>> getSocketFactoryClasses() {
        return this.fClasses;
    }

    public SocketFactoryAdministrator(IAgent agent) {
        this.fAgent = agent;
        this.fClasses = Collections.unmodifiableList(this.loadSocketFactoryPlugins());
        for (Class<?> clazz : this.fClasses) {
            try {
                Method method = clazz.getMethod("getSchema", new Class[0]);
                Object o = method.invoke(null, new Object[0]);
                if (!(o instanceof String)) continue;
                String schema = (String)o;
                ServerUrlProperty.addScheme(schema, clazz.getCanonicalName());
            }
            catch (SecurityException e) {
                this.getModuleFeedback().error(e);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
    }

    private final IAgent getAgent() {
        return this.fAgent;
    }

    private final IModuleFeedbackChannel getModuleFeedback() {
        return this.getAgent().IAgent_getModuleFeedback();
    }

    private final IStringLocalizer getStringLocalizer() {
        return this.getAgent().IAgent_getStringLocalizer();
    }

    private final ExtensionAdministrator getExtensionAdministrator() {
        return this.getAgent().IAgent_getExtensionAdministrator();
    }

    private List<Class<?>> loadSocketFactoryPlugins() {
        ExtensionAdministrator extensionAdministrator = this.getExtensionAdministrator();
        Assertion.wilyAssert(false);
        ArrayList classes = new ArrayList();
        IPlugin[] plugins = extensionAdministrator.getAgentPluginsByType(kSocketFactoryPluginType);
        if (plugins != null && plugins.length > 0) {
            try {
                for (int i = 0; i < plugins.length; ++i) {
                    Class clazz;
                    IPlugin plugin = plugins[i];
                    try {
                        clazz = ExtensionUtilities.loadEntryPointClass(this.getModuleFeedback(), this.getStringLocalizer(), plugin, 1, ISocketFactory.class);
                    }
                    catch (UnsupportedClassVersionError e) {
                        this.getModuleFeedback().info("" + plugin + " is not supported by your Java version, it will be disabled");
                        continue;
                    }
                    if (clazz == null) continue;
                    classes.add(clazz);
                    this.getModuleFeedback().verbose(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_SocketFactory_Class_Loaded_Message", clazz.getName()));
                }
            }
            catch (Throwable t) {
                this.getModuleFeedback().error(t);
            }
        }
        return classes;
    }
}

