/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.spec.server;

import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.stat.gatherer.BlameHandlingGatherer;

public class MetricNameUtils {
    public static String substituteMetricSeparatorChars(String metric) {
        String newMetric = null;
        newMetric = metric.replace(':', '%');
        newMetric = newMetric.replace('|', '%');
        return newMetric;
    }

    public static boolean containsMetricSeparatorChars(String metric) {
        if (metric == null) {
            return false;
        }
        return metric.indexOf(58) >= 0 || metric.indexOf(124) >= 0;
    }

    public static AgentMetric createCalledBackendMetric(BlameHandlingGatherer gatherer, String metricResource) {
        AgentMetric calledBackendAgentMetric = null;
        try {
            StringBuilder buffer = new StringBuilder();
            buffer.setLength(0);
            buffer.append(metricResource);
            buffer.append("|Called ");
            String backendMetric = gatherer.getMetric().getAttributeURL();
            buffer.append(backendMetric);
            String calledBackendMetric = buffer.toString();
            calledBackendAgentMetric = AgentMetric.getAgentMetric(calledBackendMetric, MetricNameUtils.getAnalogousBackendMetricType(gatherer.getMetric().getAttributeType()));
        }
        catch (BadlyFormedNameException badlyFormedNameException) {
            return null;
        }
        return calledBackendAgentMetric;
    }

    public static AgentMetric createTemporaryCalledBackendMetric(BlameHandlingGatherer gatherer, String metricResource) {
        AgentMetric calledBackendAgentMetric = null;
        try {
            StringBuilder buffer = new StringBuilder();
            buffer.setLength(0);
            buffer.append(metricResource);
            buffer.append("|Called ");
            String backendMetric = gatherer.getMetric().getAttributeURL();
            buffer.append(backendMetric);
            String calledBackendMetric = buffer.toString();
            calledBackendAgentMetric = new AgentMetric(calledBackendMetric, MetricNameUtils.getAnalogousBackendMetricType(gatherer.getMetric().getAttributeType()));
        }
        catch (BadlyFormedNameException badlyFormedNameException) {
            return null;
        }
        return calledBackendAgentMetric;
    }

    private static int getAnalogousBackendMetricType(int inMetricType) {
        int metricType = inMetricType;
        if (inMetricType == 1025) {
            metricType = 536871937;
        } else if (inMetricType == 8194) {
            metricType = 0x20002002;
        } else if (inMetricType == 257) {
            metricType = 0x20000101;
        } else if (inMetricType == 385) {
            metricType = 536871297;
        }
        return metricType;
    }
}

