/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.messageprimitives.sink;

import com.wily.isengard.message.AMessage;
import com.wily.isengard.messageprimitives.InterfaceValidationUtilities;
import com.wily.isengard.messageprimitives.InvalidIsengardInterface;
import com.wily.isengard.messageprimitives.MethodCallMessage;
import com.wily.isengard.messageprimitives.MethodCallUtilities;
import com.wily.isengard.messageprimitives.service.MessageService;
import com.wily.isengard.messageprimitives.service.MessageServiceFactory;
import com.wily.isengard.messageprimitives.sink.IMessageSink;
import com.wily.isengard.messageprimitives.sink.IMessageSinkService;
import com.wily.isengard.messageprimitives.sink.ISinkNotification;
import com.wily.isengard.postoffice.Address;
import com.wily.isengard.postoffice.IPostOfficeNotification;
import com.wily.isengard.postoffice.Mailbox;
import com.wily.isengard.postoffice.PostOffice;
import com.wily.isengard.postoffice.PostOfficeSpecifier;
import com.wily.util.exception.UnexpectedExceptionError;
import com.wily.util.feedback.Module;
import com.wily.wilyassert.Assertion;
import java.util.HashMap;
import java.util.LinkedList;

public class MessageSink<T>
extends MessageService<IMessageSinkService>
implements IMessageSinkService,
IPostOfficeNotification {
    private static final Module sModule = new Module("MessageSink");
    private Class<T> fSinkInterface;
    private HashMap<Address, IMessageSink> fPublishers;
    private MessageHandler fMessageHandler;
    private ISinkNotification fControlChannel;

    public MessageSink(PostOffice po, Class<T> sinkInterface, ISinkNotification controlChannel) throws InvalidIsengardInterface {
        super(po);
        super.initialize(IMessageSinkService.class, this);
        this.initialize(sinkInterface, controlChannel);
    }

    public MessageSink(PostOffice po, Class<T> sinkInterface) throws InvalidIsengardInterface {
        super(po);
        super.initialize(IMessageSinkService.class, this);
        try {
            this.initialize(sinkInterface, (ISinkNotification)((Object)this));
        }
        catch (ClassCastException e) {
            this.getFeedbackChannel().error(sModule, "The class " + this.getClass() + " must implement the interface ISinkNotification");
            throw new UnexpectedExceptionError(e);
        }
    }

    private void initialize(Class<T> sinkInterface, ISinkNotification controlChannel) throws InvalidIsengardInterface {
        InterfaceValidationUtilities.validateInterface(sinkInterface, IMessageSink.class);
        this.fSinkInterface = sinkInterface;
        this.fControlChannel = controlChannel;
        this.fPublishers = new HashMap();
        this.fMessageHandler = new MessageHandler(this.getPostOffice());
        this.receivePostOfficeNotification(this);
    }

    private void handleIncomingData(MethodCallMessage message) {
        IMessageSink sink = this.fPublishers.get(message.getSourceAddress());
        Assertion.wilyAssert(sink != null);
        try {
            MethodCallUtilities.callInterface(sink, message);
        }
        catch (Throwable e) {
            this.getFeedbackChannel().error(sModule, "Caught exception while handling sink message.", e);
        }
    }

    @Override
    public final Address startPublishing(Address fromAddress) {
        IMessageSink handler = this.fControlChannel.sinkPublisherStarted(fromAddress);
        this.fPublishers.put(fromAddress, handler);
        return this.fMessageHandler.getAddress();
    }

    @Override
    public final void stopPublishing(Address fromAddress) {
        this.fControlChannel.sinkPublisherStopped(fromAddress);
        this.fPublishers.remove(fromAddress);
    }

    public Class<T> getSinkClass() {
        return this.fSinkInterface;
    }

    @Override
    public void close() {
        this.cancelPostOfficeNotification(this);
        if (this.fMessageHandler != null) {
            super.close();
            this.fMessageHandler.close();
            this.fMessageHandler = null;
        }
    }

    @Override
    public final void postOfficeAdded(PostOfficeSpecifier postOffice) {
    }

    @Override
    public final void postOfficeRemoved(PostOfficeSpecifier postOffice) {
        LinkedList<Address> deleteList = new LinkedList<Address>();
        for (Address publisher : this.fPublishers.keySet()) {
            if (!publisher.getPostOffice().equals(postOffice)) continue;
            deleteList.add(publisher);
        }
        while (!deleteList.isEmpty()) {
            Address publisher;
            publisher = (Address)deleteList.removeFirst();
            this.stopPublishing(publisher);
        }
    }

    public static IMessageSinkService getInterface(PostOffice po, Address sinkAddress) {
        return MessageServiceFactory.getService(po, IMessageSinkService.class, sinkAddress);
    }

    private class MessageHandler
    extends Mailbox {
        public MessageHandler(PostOffice po) {
            super(po);
        }

        @Override
        public final void receiveMessage(AMessage message) {
            if (message instanceof MethodCallMessage) {
                MessageSink.this.handleIncomingData((MethodCallMessage)message);
            } else {
                this.getFeedbackChannel().error(sModule, "Processing unexpected message: " + message);
            }
        }
    }
}

