/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.postoffice;

import com.wily.util.adt.DefaultedMap;
import com.wily.util.io.IKeyedClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ClassLoaderManager {
    public static final String kDefaultClassLoaderName = "";
    private final Map<ClassLoader, String> fRegisteredClassLoaders;
    private final Map<String, ClassLoader> fRegisteredClassLoadersByClassName;
    private final ClassLoader fDefaultClassLoader;
    private final IKeyedClassLoader fKeyedClassLoader;
    private IKeyedClassLoader[] fKeyedClassLoaders = new IKeyedClassLoader[0];

    public ClassLoaderManager(ClassLoader defaultClassLoader) {
        this.fKeyedClassLoader = new KeyedClassLoader();
        this.fRegisteredClassLoaders = Collections.synchronizedMap(DefaultedMap.decorate(new HashMap(), kDefaultClassLoaderName));
        this.fRegisteredClassLoadersByClassName = Collections.synchronizedMap(new HashMap());
        this.fDefaultClassLoader = defaultClassLoader;
        this.registerDefaultClassLoader(this.fDefaultClassLoader);
        this.registerBootstrapClassLoader();
    }

    public ClassLoader getDefaultClassLoader() {
        return this.fDefaultClassLoader;
    }

    public Map<ClassLoader, String> getRegisteredClassLoaders() {
        return Collections.unmodifiableMap(this.fRegisteredClassLoaders);
    }

    public Map<String, ClassLoader> getRegisteredClassLoadersByClassName() {
        return Collections.unmodifiableMap(this.fRegisteredClassLoadersByClassName);
    }

    public IKeyedClassLoader getKeyedClassLoader() {
        return this.fKeyedClassLoader;
    }

    public void addKeyedClassLoader(IKeyedClassLoader clMap) {
        ArrayList<IKeyedClassLoader> newList = new ArrayList<IKeyedClassLoader>(Arrays.asList(this.fKeyedClassLoaders));
        newList.add(clMap);
        this.fKeyedClassLoaders = newList.toArray(new IKeyedClassLoader[0]);
    }

    public void removeKeyedClassLoader(IKeyedClassLoader clMap) {
        ArrayList<IKeyedClassLoader> newList = new ArrayList<IKeyedClassLoader>(Arrays.asList(this.fKeyedClassLoaders));
        newList.remove(clMap);
        this.fKeyedClassLoaders = newList.toArray(new IKeyedClassLoader[0]);
    }

    public void registerClassLoader(ClassLoader loader, String loaderName) {
        if (kDefaultClassLoaderName.equals(loaderName)) {
            throw new IllegalArgumentException("The classloader name:  is reserved for the default classloader.");
        }
        if (this.fDefaultClassLoader != null && this.fDefaultClassLoader.equals(loader)) {
            throw new IllegalArgumentException("The default classloader cannot be registered externally.");
        }
        if (loader == null) {
            throw new IllegalArgumentException("The bootstrap classloader cannot be registered externally.");
        }
        this.doUncheckedRegisterClassLoader(loader, loaderName);
    }

    public void unregisterClassLoader(ClassLoader loader, String loaderName) {
        if (loader == null) {
            throw new IllegalArgumentException("The bootstrap classloader cannot be unregistered externally.");
        }
        if (loader.equals(this.fDefaultClassLoader) || kDefaultClassLoaderName.equals(loaderName)) {
            throw new IllegalArgumentException("The default classloader cannot be unregistered externally.");
        }
        this.fRegisteredClassLoaders.remove(loader);
        this.fRegisteredClassLoadersByClassName.remove(loaderName);
    }

    private void registerDefaultClassLoader(ClassLoader loader) {
        this.doUncheckedRegisterClassLoader(loader, kDefaultClassLoaderName);
    }

    private void registerBootstrapClassLoader() {
        this.fRegisteredClassLoaders.put(null, kDefaultClassLoaderName);
    }

    private void doUncheckedRegisterClassLoader(ClassLoader loader, String loaderName) {
        this.fRegisteredClassLoaders.put(loader, loaderName);
        this.fRegisteredClassLoadersByClassName.put(loaderName, loader);
    }

    private class KeyedClassLoader
    implements IKeyedClassLoader {
        private ConcurrentHashMap<Class<?>, String> fClassCache = new ConcurrentHashMap();

        @Override
        public String getClassLoaderKey(Class clazz) {
            IKeyedClassLoader[] maps;
            String key = this.fClassCache.get(clazz);
            if (key != null) {
                return key;
            }
            IKeyedClassLoader[] iKeyedClassLoaderArray = maps = this.getClassLoaderMaps();
            int n = maps.length;
            int n2 = 0;
            while (n2 < n) {
                IKeyedClassLoader map = iKeyedClassLoaderArray[n2];
                key = map.getClassLoaderKey(clazz);
                if (key != null) {
                    this.fClassCache.put(clazz, key);
                    return key;
                }
                ++n2;
            }
            ClassLoader cl = clazz.getClassLoader();
            key = (String)ClassLoaderManager.this.fRegisteredClassLoaders.get(cl);
            this.fClassCache.put(clazz, key);
            return key;
        }

        private IKeyedClassLoader[] getClassLoaderMaps() {
            return ClassLoaderManager.this.fKeyedClassLoaders;
        }

        @Override
        public Class forName(String classLoaderKey, String className) throws ClassNotFoundException {
            IKeyedClassLoader[] maps;
            IKeyedClassLoader[] iKeyedClassLoaderArray = maps = this.getClassLoaderMaps();
            int n = maps.length;
            int n2 = 0;
            while (n2 < n) {
                IKeyedClassLoader map = iKeyedClassLoaderArray[n2];
                Class clazz = map.forName(classLoaderKey, className);
                if (clazz != null) {
                    return clazz;
                }
                ++n2;
            }
            ClassLoader cl = (ClassLoader)ClassLoaderManager.this.fRegisteredClassLoadersByClassName.get(classLoaderKey);
            if (cl == null) {
                return Class.forName(className, true, ClassLoaderManager.this.fDefaultClassLoader);
            }
            return Class.forName(className, true, cl);
        }
    }
}

