/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.util.thread;

import com.wily.util.thread.IThreadFactory;
import java.util.concurrent.CountDownLatch;

public abstract class AThreadedExecutable
implements Runnable {
    private CountDownLatch fLetChildThreadDoInitialChecks;
    private Thread fExecutionThread;
    private volatile boolean fIsExecuting;
    private volatile boolean fExternalThreadAttemptedToStart;
    private final byte[] fSynch = new byte[0];

    public AThreadedExecutable() {
        this.fLetChildThreadDoInitialChecks = new CountDownLatch(1);
    }

    public final synchronized void start(IThreadFactory threadFactory, String nameFragment) {
        this.start(threadFactory, nameFragment, 5);
    }

    /*
     * Unable to fully structure code
     */
    public final synchronized void start(IThreadFactory threadFactory, String nameFragment, int priority) {
        block7: {
            this.fExternalThreadAttemptedToStart = false;
            if (this.isExecuting()) {
                throw new IllegalStateException("This " + this.getClass().getName() + " is already started.");
            }
            this.fExecutionThread = threadFactory.IThreadFactory_createNewThread(priority, nameFragment, this);
            if (this.fExecutionThread.isAlive() || this.fExternalThreadAttemptedToStart) {
                throw new IllegalThreadStateException("The thread factory: " + threadFactory + " attempted to start the execution thread itself.");
            }
            this.fIsExecuting = true;
            try {
                this.fExecutionThread.start();
                break block7;
            }
            catch (Error e) {
                activeThreads = new Thread[Thread.activeCount()];
                Thread.enumerate(activeThreads);
                System.err.println("Caught OutOfMemoryException: Dumping threads");
                i = 0;
                ** while (i < activeThreads.length)
            }
lbl-1000:
            // 1 sources

            {
                System.err.println("  Running thread " + i + ": " + activeThreads[i]);
                ++i;
                continue;
            }
lbl21:
            // 1 sources

            throw e;
        }
        try {
            this.fLetChildThreadDoInitialChecks.await();
        }
        catch (InterruptedException v0) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void stop(boolean blockUntilFinished) {
        if (!this.isExecuting()) return;
        byte[] byArray = this.fSynch;
        synchronized (this.fSynch) {
            this.fIsExecuting = false;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.interruptExecutionIfNonReentrant();
            if (!blockUntilFinished) return;
            this.blockUntilExecutionFinished(Integer.MAX_VALUE);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final synchronized void stop(int blockTime) {
        if (!this.isExecuting()) return;
        byte[] byArray = this.fSynch;
        synchronized (this.fSynch) {
            this.fIsExecuting = false;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.interruptExecutionIfNonReentrant();
            this.blockUntilExecutionFinished(blockTime);
            return;
        }
    }

    public final boolean isExecuting() {
        return this.fIsExecuting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        try {
            this.doInitialChecks();
        }
        finally {
            this.fLetChildThreadDoInitialChecks.countDown();
        }
        try {
            this.doTask();
        }
        catch (Throwable throwable) {
            byte[] byArray = this.fSynch;
            synchronized (this.fSynch) {
                this.fIsExecuting = false;
                // ** MonitorExit[var2_3] (shouldn't be in output)
                throw throwable;
            }
        }
        byte[] byArray = this.fSynch;
        synchronized (this.fSynch) {
            this.fIsExecuting = false;
            // ** MonitorExit[var2_4] (shouldn't be in output)
            return;
        }
    }

    protected final void blockUntilExecutionFinished(int blockTime) {
        if (!this.isInvokingThreadSameAsExecutionThread()) {
            try {
                this.fExecutionThread.join(blockTime);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected final boolean isInvokingThreadSameAsExecutionThread() {
        return Thread.currentThread() == this.fExecutionThread;
    }

    protected abstract void doTask();

    private void interruptExecutionIfNonReentrant() {
        if (!this.isInvokingThreadSameAsExecutionThread()) {
            this.fExecutionThread.interrupt();
        }
    }

    private void doInitialChecks() {
        if (!this.isExecuting()) {
            this.fExternalThreadAttemptedToStart = true;
            throw new IllegalStateException("run() should not be invoked directly.");
        }
    }
}

