/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.adt;

import com.wily.util.adt.IConcurrentBlockingQueue;
import com.wily.util.adt.IConcurrentLinkedQueueFactory;
import com.wily.util.adt.IConcurrentQueue;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.IndexedProperties;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;

public class ConcurrentLinkedQueueFactory
implements IConcurrentLinkedQueueFactory {
    public ConcurrentLinkedQueueFactory() {
    }

    public ConcurrentLinkedQueueFactory(IModuleFeedbackChannel feedback, IndexedProperties properties) {
    }

    @Override
    public IConcurrentBlockingQueue getConcurrentBlockingQueue() {
        return new IConcurrentBlockingQueue(){
            private final ConcurrentLinkedQueue backingQueue = new ConcurrentLinkedQueue();
            private final ConcurrentLinkedQueue<Thread> consumers = new ConcurrentLinkedQueue();

            @Override
            public void offer(Object o) {
                this.backingQueue.offer(o);
                Thread t = this.consumers.poll();
                if (t != null) {
                    LockSupport.unpark(t);
                }
            }

            @Override
            public Object poll() {
                return this.backingQueue.poll();
            }

            @Override
            public void put(Object o) {
                this.backingQueue.offer(o);
                Thread t = this.consumers.poll();
                if (t != null) {
                    LockSupport.unpark(t);
                }
            }

            @Override
            public Object take() {
                Object o = null;
                while (o == null) {
                    o = this.backingQueue.poll();
                    if (o != null) continue;
                    Thread t = Thread.currentThread();
                    this.consumers.offer(t);
                    LockSupport.parkNanos(1000000000L);
                    this.consumers.remove(t);
                }
                return o;
            }

            @Override
            public Object peek() {
                return this.backingQueue.peek();
            }
        };
    }

    @Override
    public IConcurrentBlockingQueue getConcurrentBlockingQueueSingleConsumer() {
        return new IConcurrentBlockingQueue(){
            private final ConcurrentLinkedQueue backingQueue = new ConcurrentLinkedQueue();
            private AtomicReference<Thread> consumer = new AtomicReference<Object>(null);

            @Override
            public void offer(Object o) {
                this.backingQueue.offer(o);
                Thread c = this.consumer.get();
                if (c != null) {
                    LockSupport.unpark(c);
                }
            }

            @Override
            public Object poll() {
                return this.backingQueue.poll();
            }

            @Override
            public void put(Object o) {
                this.backingQueue.offer(o);
                Thread c = this.consumer.get();
                if (c != null) {
                    LockSupport.unpark(c);
                }
            }

            @Override
            public Object take() {
                Object o = null;
                while (o == null) {
                    o = this.backingQueue.poll();
                    if (o != null) continue;
                    Thread t = Thread.currentThread();
                    this.consumer.set(t);
                    LockSupport.parkNanos(1000000000L);
                    this.consumer.set(null);
                    if (!Thread.interrupted()) continue;
                    return null;
                }
                return o;
            }

            @Override
            public Object peek() {
                return this.backingQueue.peek();
            }
        };
    }

    @Override
    public IConcurrentQueue getConcurrentQueue() {
        return new IConcurrentQueue(){
            private final ConcurrentLinkedQueue backingQueue = new ConcurrentLinkedQueue();

            @Override
            public void offer(Object o) {
                this.backingQueue.offer(o);
            }

            @Override
            public Object poll() {
                return this.backingQueue.poll();
            }

            @Override
            public Object peek() {
                return this.backingQueue.peek();
            }
        };
    }
}

