/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.adt;

public final class TwoObjectIdentityHashSet {
    private static final int kDefaultInitialCapacity = 11;
    private static final float kLoadFactor = 0.75f;
    private Entry[] fTable;
    private int fCount;

    public TwoObjectIdentityHashSet() {
        this(11);
    }

    public TwoObjectIdentityHashSet(int initialCapacity) {
        if (initialCapacity < 1) {
            throw new IllegalArgumentException("Capacity must be positive: " + initialCapacity);
        }
        this.fTable = new Entry[initialCapacity];
        this.fCount = 0;
    }

    public int size() {
        return this.fCount;
    }

    public boolean add(Object value1, Object value2) {
        Entry newEntry;
        int hashcode = System.identityHashCode(value1) + System.identityHashCode(value2);
        int index = (hashcode & Integer.MAX_VALUE) % this.fTable.length;
        Entry e = this.fTable[index];
        while (e != null) {
            if (e.fValue1 == value1 && e.fValue2 == value2) {
                return false;
            }
            e = e.fNext;
        }
        e = this.fTable[index];
        this.fTable[index] = newEntry = new Entry(hashcode, value1, value2, e);
        ++this.fCount;
        if ((float)this.fCount > (float)this.fTable.length * 0.75f) {
            this.rehash();
        }
        return true;
    }

    public boolean remove(Object value1, Object value2) {
        int hashcode = System.identityHashCode(value1) + System.identityHashCode(value2);
        int index = (hashcode & Integer.MAX_VALUE) % this.fTable.length;
        Entry previous = null;
        Entry e = this.fTable[index];
        while (e != null) {
            if (e.fValue1 == value1 && e.fValue2 == value2) {
                if (previous == null) {
                    this.fTable[index] = e.fNext;
                } else {
                    previous.fNext = e.fNext;
                }
                --this.fCount;
                return true;
            }
            previous = e;
            e = e.fNext;
        }
        return false;
    }

    public boolean contains(Object value1, Object value2) {
        int hashcode = System.identityHashCode(value1) + System.identityHashCode(value2);
        Entry e = this.fTable[(hashcode & Integer.MAX_VALUE) % this.fTable.length];
        while (e != null) {
            if (e.fValue1 == value1 && e.fValue2 == value2) {
                return true;
            }
            e = e.fNext;
        }
        return false;
    }

    private void rehash() {
        Entry[] newTable = new Entry[this.fTable.length * 2 + 1];
        int i = 0;
        while (i < this.fTable.length) {
            Entry e = this.fTable[i];
            Entry nextE = null;
            while (e != null) {
                Entry newNext;
                nextE = e.fNext;
                int newIndex = (e.fHashcode & Integer.MAX_VALUE) % newTable.length;
                e.fNext = newNext = newTable[newIndex];
                newTable[newIndex] = e;
                e = nextE;
            }
            ++i;
        }
        this.fTable = newTable;
    }

    private static final class Entry {
        final int fHashcode;
        final Object fValue1;
        final Object fValue2;
        Entry fNext;

        private Entry(int hashcode, Object value1, Object value2, Entry next) {
            this.fHashcode = hashcode;
            this.fValue1 = value1;
            this.fValue2 = value2;
            this.fNext = next;
        }
    }
}

