/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.adt.trie;

import com.wily.util.adt.primitive.CharObjMapEntry;
import com.wily.util.adt.primitive.PrimitiveCharObjMap;
import com.wily.util.adt.trie.TrieNode;

public class Trie {
    private TrieNode root = new TrieNode();
    private int memberCount = 0;
    private final boolean synch;

    public Trie() {
        this.synch = false;
    }

    public Trie(boolean synch) {
        this.synch = synch;
    }

    public TrieNode getRoot() {
        return this.root;
    }

    public int getMemberCount() {
        return this.memberCount;
    }

    public void insert(String word) {
        TrieNode current = this.root;
        int i = 0;
        int n = word.length();
        while (i < n) {
            char temp = word.charAt(i);
            PrimitiveCharObjMap<TrieNode> children = current.getChildrenForInsert(this.synch);
            if ((current = children.get(temp)) == null) {
                current = new TrieNode();
                children.put(temp, current);
            }
            ++i;
        }
        if (!current.isEndOfWord()) {
            current.setEndOfWord(true);
            ++this.memberCount;
        }
    }

    public boolean deleteEntry(String word) {
        return this.delete(this.root, word, 0);
    }

    public boolean contains(String word) {
        TrieNode current = this.root;
        int i = 0;
        while (i < word.length()) {
            PrimitiveCharObjMap<TrieNode> children = current.getChildren();
            if (children == null) {
                return false;
            }
            char temp = word.charAt(i);
            current = children.get(temp);
            if (current == null) {
                return false;
            }
            ++i;
        }
        return current.isEndOfWord();
    }

    public boolean isEmpty() {
        return this.root.getChildren() == null;
    }

    private boolean delete(TrieNode current, String word, int index) {
        boolean shouldDeleteCurrentNode;
        PrimitiveCharObjMap<TrieNode> children = current.getChildren();
        if (index == word.length()) {
            if (!current.isEndOfWord()) {
                return false;
            }
            current.setEndOfWord(false);
            --this.memberCount;
            return children == null || children.isEmpty();
        }
        if (children == null) {
            return false;
        }
        char temp = word.charAt(index);
        TrieNode child = children.get(temp);
        if (child == null) {
            return false;
        }
        boolean bl = shouldDeleteCurrentNode = this.delete(child, word, index + 1) && !child.isEndOfWord();
        if (shouldDeleteCurrentNode) {
            children.remove(temp);
            if (children.isEmpty()) {
                current.setChildrenToNull();
                return true;
            }
        }
        return false;
    }

    public void merge(Trie other) {
        this.mergeTries(this.getRoot(), other.getRoot());
        this.memberCount += other.getMemberCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeTries(TrieNode thisTrie, TrieNode otherTrie) {
        if (otherTrie.isEndOfWord()) {
            if (thisTrie.isEndOfWord()) {
                --this.memberCount;
            } else {
                thisTrie.setEndOfWord(true);
            }
        }
        if (otherTrie.getChildren() == null) {
            return;
        }
        if (thisTrie.getChildren() == null) {
            PrimitiveCharObjMap<TrieNode> thisMap = thisTrie.getChildrenForInsert(this.synch);
            PrimitiveCharObjMap<TrieNode> primitiveCharObjMap = otherTrie.getChildren();
            synchronized (primitiveCharObjMap) {
                for (CharObjMapEntry<TrieNode> charObjMapEntry : otherTrie.getChildren()) {
                    thisMap.put(charObjMapEntry.getKey(), new TrieNode(charObjMapEntry.getValue(), this.synch));
                }
            }
            return;
        }
        PrimitiveCharObjMap<TrieNode> thisChildren = thisTrie.getChildren();
        PrimitiveCharObjMap<TrieNode> primitiveCharObjMap = otherTrie.getChildren();
        synchronized (primitiveCharObjMap) {
            for (CharObjMapEntry<TrieNode> charObjMapEntry : otherTrie.getChildren()) {
                if (thisChildren.containsKey(charObjMapEntry.getKey())) {
                    this.mergeTries(thisChildren.get(charObjMapEntry.getKey()), charObjMapEntry.getValue());
                    continue;
                }
                thisChildren.put(charObjMapEntry.getKey(), new TrieNode(charObjMapEntry.getValue(), this.synch));
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Trie)) {
            return false;
        }
        Trie trie = (Trie)o;
        return this.root != null ? this.root.equals(trie.root) : trie.root == null;
    }

    public int hashCode() {
        return this.root != null ? this.root.hashCode() : 0;
    }
}

