/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.extension;

import com.wily.util.StringUtils;
import com.wily.util.adt.AttributesStringDictionaryReader;
import com.wily.util.adt.IStringDictionaryReader;
import com.wily.util.exception.UnexpectedExceptionError;
import com.wily.util.extension.AExtension;
import com.wily.util.extension.EagerAllPermissionsClassLoader;
import com.wily.util.extension.ExtensionStringLocalizer;
import com.wily.util.extension.IPlugin;
import com.wily.util.extension.InMemoryJarClassLoader;
import com.wily.util.extension.InMemoryJarFile;
import com.wily.util.extension.InvalidExtensionException;
import com.wily.util.extension.JarURLPhysicalModule;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.io.IConstructorExternalizable;
import com.wily.util.text.IStringLocalizer;
import com.wily.util.text.MultipleResourceBundleStringLocalizer;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.List;
import java.util.jar.JarFile;

public class MemoryExtension
extends AExtension
implements IConstructorExternalizable {
    private final InMemoryJarFile fJarFile;
    private String fName;
    private String fClassloaderKey;
    private String fType;
    private int fVersion;
    private List fDependencies;
    private MultipleResourceBundleStringLocalizer fExtensionLocalizer;
    private List fPluginList;
    private ClassLoader fParentLoader;
    private IStringDictionaryReader fAttributesReader;
    private ClassLoader fClassLoader;
    private int fRank;
    private IModuleFeedbackChannel fModuleFeedback;

    public MemoryExtension(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fJarFile = (InMemoryJarFile)in.readObject();
        try {
            super.initialize(this.fJarFile.getName(), this.fJarFile.getMainAttributes());
            this.initialize(null, this.getClass().getClassLoader());
        }
        catch (InvalidExtensionException e) {
            throw new UnexpectedExceptionError(e);
        }
    }

    public MemoryExtension(JarFile jarFile, IModuleFeedbackChannel feedback, ClassLoader parentClassLoader) throws IOException, InvalidExtensionException {
        this.fJarFile = new InMemoryJarFile(jarFile);
        super.initialize(jarFile.getName(), this.fJarFile.getMainAttributes());
        this.initialize(feedback, parentClassLoader);
    }

    private void initialize(IModuleFeedbackChannel feedback, ClassLoader parentClassLoader) throws InvalidExtensionException {
        this.fName = this.getMainAttributeValueOrThrow("com-wily-Extension-Name");
        this.fModuleFeedback = feedback;
        this.fClassloaderKey = this.getMainAttributeValue("com-wily-Extension-Classloader-Key");
        this.fType = this.getMainAttributeValue("com-wily-Extension-Type");
        String commaSeparatedDependencies = this.getMainAttributeValue("com-wily-Extension-depends-on");
        String[] deps = commaSeparatedDependencies == null ? new String[]{} : StringUtils.parseAndTrimList(commaSeparatedDependencies, ",");
        this.fDependencies = Arrays.asList(deps);
        this.fVersion = this.getValidatedVersion();
        this.fPluginList = this.buildPluginList(this, this.getMainAttributeValueOrThrow("com-wily-Extension-Plugins-List"));
        this.fExtensionLocalizer = this.buildStringLocalizer(feedback, parentClassLoader, this.getMainAttributeValue("com-wily-Extension-Localized-Resource-List"));
        this.fAttributesReader = new AttributesStringDictionaryReader(this.fJarFile.getMainAttributes());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.fJarFile);
    }

    @Override
    public String IExtension_getName() {
        return this.fName;
    }

    @Override
    public void IExtension_setParentClassLoader(ClassLoader loader) throws InvalidExtensionException {
        this.fParentLoader = loader = JarURLPhysicalModule.getBundleClassLoaders(this.fModuleFeedback, loader, this.fJarFile);
        this.fClassLoader = new InMemoryJarClassLoader(this.fParentLoader, this.fJarFile);
    }

    @Override
    public String IExtension_getClassloaderKey() {
        return this.fClassloaderKey;
    }

    @Override
    public String IExtension_getType() {
        return this.fType;
    }

    @Override
    public int IExtension_getVersion() {
        return this.fVersion;
    }

    @Override
    public String IExtension_getSource() {
        return this.fJarFile.getName();
    }

    @Override
    public String[] IExtension_getDependencies() {
        return this.fDependencies.toArray(new String[0]);
    }

    @Override
    public ClassLoader IExtension_getClassLoader() {
        return this.fClassLoader;
    }

    @Override
    public IStringLocalizer IExtension_getStringLocalizer(IStringLocalizer fallback) {
        return new ExtensionStringLocalizer(this.fExtensionLocalizer, fallback);
    }

    @Override
    public IPlugin[] IExtension_getFilteredPluginList(String pluginFilter) {
        return this.getFilteredPluginList(this.fPluginList, pluginFilter);
    }

    @Override
    public IStringDictionaryReader IExtension_getAttributes() {
        return this.fAttributesReader;
    }

    @Override
    public String ITopologicalSortNode_getId() {
        return this.IExtension_getName();
    }

    @Override
    public String[] ITopologicalSort_getDependencies() {
        return this.IExtension_getDependencies();
    }

    @Override
    public int ITopologicalSort_getRank() {
        return this.fRank;
    }

    @Override
    public void ITopologicalSort_setRank(int v) {
        this.fRank = v;
    }

    @Override
    public void IExtension_load() {
        this.load();
        this.loadPlugins(this.fPluginList);
    }

    @Override
    public void IExtension_unload() {
        this.unloadPlugins(this.fPluginList);
        this.unload();
        if (this.fClassLoader instanceof Closeable) {
            try {
                ((Closeable)((Object)this.fClassLoader)).close();
            }
            catch (IOException iOException) {}
        }
        if (this.fClassLoader instanceof EagerAllPermissionsClassLoader) {
            try {
                ((EagerAllPermissionsClassLoader)this.fClassLoader).closeInternal();
            }
            catch (IOException iOException) {}
        }
        this.fClassLoader = null;
        this.fParentLoader = null;
        System.gc();
    }
}

