/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.feedback;

import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.feedback.SeverityLevel;
import com.wily.util.feedback.util.LoggingHelper;

public class DelegatingFeedbackChannel
implements IModuleFeedbackChannel {
    protected final IModuleFeedbackChannel fDelegate;
    protected final Module fModule;

    public DelegatingFeedbackChannel(IModuleFeedbackChannel delegate, Module module) {
        this.fDelegate = delegate;
        this.fModule = module;
    }

    @Override
    public void debug(String message) {
        this.fDelegate.debug(this.fModule, message);
    }

    @Override
    public void debug(String message, Throwable t) {
        this.fDelegate.debug(this.fModule, message, t);
    }

    @Override
    public void debug(Throwable t) {
        this.fDelegate.debug(this.fModule, null, t);
    }

    @Override
    public void debug(Module module, String message) {
        this.fDelegate.debug(module, message);
    }

    @Override
    public void debug(Module module, String message, Throwable t) {
        this.fDelegate.debug(module, message, t);
    }

    @Override
    public void error(String message) {
        this.fDelegate.error(this.fModule, message);
        LoggingHelper.updateErrorCount();
    }

    @Override
    public void error(String message, Throwable t) {
        this.fDelegate.error(this.fModule, message, t);
        LoggingHelper.updateErrorCount();
    }

    @Override
    public void error(Throwable t) {
        this.fDelegate.error(this.fModule, null, t);
        LoggingHelper.updateErrorCount();
    }

    @Override
    public void error(Module module, String message) {
        this.fDelegate.error(module, message);
        LoggingHelper.updateErrorCount();
    }

    @Override
    public void error(Module module, String message, Throwable t) {
        this.fDelegate.error(module, message, t);
        LoggingHelper.updateErrorCount();
    }

    @Override
    public String getApplicationName() {
        return this.fDelegate.getApplicationName();
    }

    @Override
    public SeverityLevel getEffectiveLevel(Module module) {
        return this.fDelegate.getEffectiveLevel(module);
    }

    @Override
    public SeverityLevel getLevel(Module module) {
        return this.fDelegate.getLevel(module);
    }

    @Override
    public String getModuleName() {
        return this.fModule.getName();
    }

    @Override
    public void info(String message) {
        this.fDelegate.info(this.fModule, message);
    }

    @Override
    public void info(String message, Throwable t) {
        this.fDelegate.info(this.fModule, message, t);
    }

    @Override
    public void info(Module module, String message) {
        this.fDelegate.info(module, message);
    }

    @Override
    public void info(Module module, String message, Throwable t) {
        this.fDelegate.info(module, message, t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.fDelegate.isDebugEnabled(this.fModule);
    }

    @Override
    public boolean isDebugEnabled(Module module) {
        return this.fDelegate.isDebugEnabled(module);
    }

    @Override
    public boolean isErrorEnabled(Module module) {
        return this.fDelegate.isErrorEnabled(module);
    }

    @Override
    public boolean isInfoEnabled(Module module) {
        return this.fDelegate.isInfoEnabled(module);
    }

    @Override
    public boolean isLogEnabled(SeverityLevel severity, Module module) {
        return this.fDelegate.isLogEnabled(severity, module);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.fDelegate.isTraceEnabled(this.fModule);
    }

    @Override
    public boolean isTraceEnabled(Module module) {
        return this.fDelegate.isTraceEnabled(module);
    }

    @Override
    public boolean isVerboseEnabled() {
        return this.fDelegate.isVerboseEnabled(this.fModule);
    }

    @Override
    public boolean isVerboseEnabled(Module module) {
        return this.fDelegate.isVerboseEnabled(module);
    }

    @Override
    public boolean isWarningEnabled(Module module) {
        return this.fDelegate.isWarningEnabled(module);
    }

    @Override
    public void log(SeverityLevel severity, String message) {
        this.fDelegate.log(severity, this.fModule, message);
        this.updateCount(severity);
    }

    private void updateCount(SeverityLevel severity) {
        if (severity.getLevelNumber() == 1) {
            LoggingHelper.updateErrorCount();
        } else if (severity.getLevelNumber() == 2) {
            LoggingHelper.updateWarningCount();
        }
    }

    @Override
    public void log(SeverityLevel severity, String message, Throwable t) {
        this.fDelegate.log(severity, this.fModule, message, t);
        this.updateCount(severity);
    }

    @Override
    public void log(SeverityLevel severity, Module module, String message) {
        this.fDelegate.log(severity, module, message);
        this.updateCount(severity);
    }

    @Override
    public void log(SeverityLevel severity, Module module, String message, Throwable t) {
        this.fDelegate.log(severity, module, message, t);
        this.updateCount(severity);
    }

    @Override
    public void logImmediate(SeverityLevel severity, Module module, String message) {
        this.fDelegate.logImmediate(severity, module, message);
        this.updateCount(severity);
    }

    @Override
    public void logImmediate(SeverityLevel severity, Module module, String message, Throwable t) {
        this.fDelegate.logImmediate(severity, module, message, t);
        this.updateCount(severity);
    }

    @Override
    public void setLevel(SeverityLevel level, Module module) {
        this.fDelegate.setLevel(level, module);
    }

    @Override
    public void trace(String message) {
        this.fDelegate.trace(this.fModule, message);
    }

    @Override
    public void trace(Module module, String message) {
        this.fDelegate.trace(module, message);
    }

    @Override
    public void trace(Module module, String message, Throwable t) {
        this.fDelegate.trace(module, message, t);
    }

    @Override
    public void verbose(String message) {
        this.fDelegate.verbose(this.fModule, message);
    }

    @Override
    public void verbose(String message, Throwable t) {
        this.fDelegate.verbose(this.fModule, message, t);
    }

    @Override
    public void verbose(Throwable t) {
        this.fDelegate.verbose(this.fModule, null, t);
    }

    @Override
    public void verbose(Module module, String message) {
        this.fDelegate.verbose(module, message);
    }

    @Override
    public void verbose(Module module, String message, Throwable t) {
        this.fDelegate.verbose(module, message, t);
    }

    @Override
    public void warn(String message) {
        this.fDelegate.warn(this.fModule, message);
        LoggingHelper.updateWarningCount();
    }

    @Override
    public void warn(String message, Throwable t) {
        this.fDelegate.warn(this.fModule, message, t);
        LoggingHelper.updateWarningCount();
    }

    @Override
    public void warn(Module module, String message) {
        this.fDelegate.warn(module, message);
        LoggingHelper.updateWarningCount();
    }

    @Override
    public void warn(Module module, String message, Throwable t) {
        this.fDelegate.warn(module, message, t);
        LoggingHelper.updateWarningCount();
    }
}

