/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.finder;

import com.wily.util.finder.IResourceFinder;
import com.wily.util.finder.IResourceFinderFeedback;
import com.wily.util.resource.IResource;
import com.wily.util.resource.SystemResourceBasedResource;
import com.wily.util.text.ALocalizableException;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.util.Properties;

public class SystemResourceResourceFinder
implements IResourceFinder {
    private final String fSystemProperty;
    private final String fResourceToFindNameKey;

    public SystemResourceResourceFinder(String systemProperty, String resourceToFindNameKey) {
        Assertion.wilyAssert(resourceToFindNameKey != null);
        Assertion.wilyAssert(systemProperty != null);
        this.fSystemProperty = systemProperty;
        this.fResourceToFindNameKey = resourceToFindNameKey;
    }

    @Override
    public IResource IResourceFinder_findResource(IResourceFinderFeedback feedback) {
        SystemResourceBasedResource resultResource = null;
        String statusMessage = "";
        String resourcePath = null;
        IStringLocalizer localizer = feedback.IResourceFinderFeedback_getStringLocalizer();
        try {
            statusMessage = localizer.IStringLocalizer_getFormattedLocalizedString("Resource_Finder_System_Property_Attempt_Message", this.fResourceToFindNameKey, true, "Resource_Finder_Embedded_Resource_Type", true, this.fSystemProperty, false);
            feedback.IResourceFinderFeedback_feedbackStatus(statusMessage);
            resourcePath = System.getProperty(this.fSystemProperty);
            if (resourcePath != null) {
                statusMessage = localizer.IStringLocalizer_getFormattedLocalizedString("Resource_Finder_Loader_Attempt_Message", "Resource_Finder_Embedded_Resource_Type", true, resourcePath, false);
                feedback.IResourceFinderFeedback_feedbackStatus(statusMessage);
                resultResource = new SystemResourceBasedResource(resourcePath, localizer);
                new Properties().load(resultResource.IResource_getContents());
                statusMessage = localizer.IStringLocalizer_getFormattedLocalizedString("Resource_Finder_Succeeded_Message", "Resource_Finder_Embedded_Resource_Type", true, resourcePath, false);
                feedback.IResourceFinderFeedback_feedbackSuccess(statusMessage);
            } else {
                statusMessage = localizer.IStringLocalizer_getFormattedLocalizedString("Resource_Finder_Resource_Not_Found_Message", this.fResourceToFindNameKey, true, "Resource_Finder_System_Property_Type", true);
                feedback.IResourceFinderFeedback_feedbackFailure(statusMessage);
            }
        }
        catch (ALocalizableException ale) {
            ale.ILocalizableException_getLocalizableMessage().ILocalizableMessage_getLocalizedMessage(localizer);
            feedback.IResourceFinderFeedback_feedbackFailure(localizer.IStringLocalizer_getFormattedLocalizedString("Resource_Finder_Resource_Not_Found_Message", this.fResourceToFindNameKey, true, "Resource_Finder_Embedded_Resource_Type", true));
        }
        catch (Throwable t) {
            statusMessage = localizer.IStringLocalizer_getFormattedLocalizedString("Resource_Finder_Failed_Message", resourcePath, t.getClass().getName(), t.getMessage());
            feedback.IResourceFinderFeedback_feedbackFailure(statusMessage);
            resultResource = null;
        }
        return resultResource;
    }
}

