/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.properties;

import com.wily.util.properties.PrefixedKeysIterator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class EnvironmentPropertiesHandler {
    private final HashMap<String, String> envMap = new HashMap();
    private final String prefix = "apmenv_";
    private static AtomicReference<EnvironmentPropertiesHandler> instance = new AtomicReference();
    private volatile boolean hasData = false;

    private EnvironmentPropertiesHandler() {
        this.buildApmEnvEntriesMap(System.getenv());
    }

    private EnvironmentPropertiesHandler(Map<String, String> map) {
        this.buildApmEnvEntriesMap(map);
    }

    static EnvironmentPropertiesHandler fromMap(Map<String, String> map) {
        return new EnvironmentPropertiesHandler(map);
    }

    public static EnvironmentPropertiesHandler getInstance() {
        EnvironmentPropertiesHandler environmentPropertiesHandler = instance.get();
        if (environmentPropertiesHandler != null) {
            return environmentPropertiesHandler;
        }
        instance.compareAndSet(null, new EnvironmentPropertiesHandler());
        return instance.get();
    }

    private void buildApmEnvEntriesMap(Map<String, String> map) {
        try {
            if (!map.isEmpty()) {
                PrefixedKeysIterator iterator = new PrefixedKeysIterator(map.keySet().iterator(), "apmenv_", false);
                StringBuilder builder = new StringBuilder(100);
                while (iterator.hasNext()) {
                    String translatedKey;
                    String key = iterator.next();
                    String value = map.get(key);
                    if (value == null || value.isEmpty() || (translatedKey = this.parseKey(builder, key.toLowerCase(Locale.US).trim(), "apmenv_")).isEmpty()) continue;
                    this.envMap.put(translatedKey, value);
                    String normalCaseTranslatedKey = this.parseKey(builder, key.trim(), "apmenv_");
                    if (!translatedKey.equals(normalCaseTranslatedKey)) {
                        this.envMap.put(normalCaseTranslatedKey, value);
                    }
                    this.hasData = true;
                }
            }
        }
        catch (Exception exception) {}
    }

    private String parseKey(StringBuilder builder, String envKey, String prefix) {
        builder.setLength(0);
        int length = envKey.length();
        int i = prefix.length();
        while (i < length) {
            char x = envKey.charAt(i);
            if (x == '_') {
                builder.append('.');
            } else {
                builder.append(x);
            }
            ++i;
        }
        return builder.toString();
    }

    static EnvironmentPropertiesHandler newSingletonInstance() {
        return EnvironmentPropertiesHandler.newSingletonInstance(new EnvironmentPropertiesHandler());
    }

    static EnvironmentPropertiesHandler newSingletonInstance(EnvironmentPropertiesHandler newInstance) {
        instance.set(newInstance);
        return instance.get();
    }

    public boolean hasData() {
        return this.hasData;
    }

    public String getProperty(String key) {
        if (this.hasData) {
            return this.envMap.get(key.toLowerCase(Locale.US));
        }
        return null;
    }

    public Set<String> getAllKeys() {
        if (this.hasData) {
            return Collections.unmodifiableSet(this.envMap.keySet());
        }
        return null;
    }

    public Map<String, String> getEnvMap() {
        return this.envMap;
    }
}

